/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.CanalRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.DetalleCanalRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.CanalResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleCanalResponseDto;
import com.dacrt.SBIABackend.entity.Canal;
import com.dacrt.SBIABackend.service.CanalService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/canales"})
@CrossOrigin(origins={"*"})
public class CanalControler {
    private final CanalService canalService;
    Logger logger = LoggerFactory.getLogger(CanalControler.class);
    Date fechaActual = new Date();

    @Autowired
    public CanalControler(CanalService canalService) {
        this.canalService = canalService;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<CanalResponseDto> addCanal(@RequestBody CanalRequestDto canalRequestDto) {
        try {
            if (StringUtils.isBlank((CharSequence)canalRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)canalRequestDto.getDescripcion()) || canalRequestDto.getActivo() == 0 || canalRequestDto.getTipoCanal() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (canalRequestDto.getNombre().length() > 200 || canalRequestDto.getDescripcion().length() > 400 || String.valueOf(canalRequestDto.getActivo()).length() > 1 || String.valueOf(canalRequestDto.getTipoCanal()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.canalService.existsByNombre(canalRequestDto.getNombre())) {
                this.logger.warn("Ya se encuentra registrado el nombre del canal Nombre: " + canalRequestDto.getNombre());
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el nombre del canal"), HttpStatus.BAD_REQUEST);
            }
            CanalResponseDto canalResponseDto = this.canalService.addCanal(canalRequestDto);
            this.logger.warn("Canal agregado canal: " + canalResponseDto.getNombre());
            return new ResponseEntity((Object)canalResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @GetMapping(value={"/detail/{id_canal}"})
    public ResponseEntity<DetalleCanalResponseDto> getCanal(@PathVariable Integer id_canal) {
        if (!this.canalService.existsById(id_canal)) {
            this.logger.warn("No existe el id del canal solicitado: " + id_canal);
            return new ResponseEntity((Object)new Mensaje("No existe el id del canal solicitado"), HttpStatus.NOT_FOUND);
        }
        DetalleCanalResponseDto canalResponseDto = this.canalService.getCanalById(id_canal);
        return new ResponseEntity((Object)canalResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleCanalResponseDto>> getCanales() {
        List<DetalleCanalResponseDto> canalResponseDtos = this.canalService.getCanales();
        return new ResponseEntity(canalResponseDtos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_canal}"})
    public ResponseEntity<?> deleteCanal(@RequestBody CanalRequestDto canalRequestDto, @PathVariable Integer id_canal) {
        try {
            if (!this.canalService.existsById(id_canal)) {
                this.logger.warn("No existe el id del canal solicitado: " + id_canal);
                return new ResponseEntity((Object)new Mensaje("No existe el id del canal solicitado"), HttpStatus.NOT_FOUND);
            }
            Canal canal = this.canalService.getOne(id_canal).get();
            int valor = canal.getActivo() == 1 ? 2 : 1;
            canal.setNombre(canal.getNombre());
            canal.setDescripcion(canal.getDescripcion());
            canal.setActivo(valor);
            canal.setTipoCanal(canal.getTipoCanal());
            canal.setUsuario(canal.getUsuario());
            canal.setFechaModificacion(this.fechaActual);
            canal.setFechaRegistro(canal.getFechaRegistro());
            this.canalService.save(canal);
            if (canal.getActivo() == 1) {
                this.logger.warn("El canal con id " + id_canal + " fue activado");
                return new ResponseEntity((Object)new Mensaje("El canal con id " + id_canal + " fue activado"), HttpStatus.OK);
            }
            this.logger.warn("El canal con id " + id_canal + " fue desactivado");
            return new ResponseEntity((Object)new Mensaje("El canal con id " + id_canal + " fue desactivado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_canal}"})
    public ResponseEntity<DetalleCanalResponseDto> editCanal(@RequestBody DetalleCanalRequestDto detalleCanalRequestDto, @PathVariable Integer id_canal) {
        try {
            if (!this.canalService.existsById(id_canal)) {
                this.logger.warn("No existe el id del canal solicitado" + id_canal);
                return new ResponseEntity((Object)new Mensaje("No existe el id del canal solicitado"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleCanalRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)detalleCanalRequestDto.getDescripcion()) || detalleCanalRequestDto.getActivo() == 0 || detalleCanalRequestDto.getTipoCanal() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleCanalRequestDto.getNombre().length() > 200 || detalleCanalRequestDto.getDescripcion().length() > 400 || String.valueOf(detalleCanalRequestDto.getActivo()).length() > 1 || String.valueOf(detalleCanalRequestDto.getTipoCanal()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.canalService.existsByNombre(detalleCanalRequestDto.getNombre()) && this.canalService.getByNombre(detalleCanalRequestDto.getNombre()).get().getId_canal() != id_canal.intValue()) {
                this.logger.warn("El nombre del canal " + detalleCanalRequestDto.getNombre() + "ya existe");
                return new ResponseEntity((Object)new Mensaje("El nombre del canal ya existe"), HttpStatus.BAD_REQUEST);
            }
            CanalRequestDto canalRequestDto = new CanalRequestDto();
            canalRequestDto.setNombre(detalleCanalRequestDto.getNombre());
            canalRequestDto.setDescripcion(detalleCanalRequestDto.getDescripcion());
            canalRequestDto.setActivo(detalleCanalRequestDto.getActivo());
            canalRequestDto.setTipoCanal(detalleCanalRequestDto.getTipoCanal());
            canalRequestDto.setUsuario(detalleCanalRequestDto.getUsuario());
            canalRequestDto.setFechaModificacion(detalleCanalRequestDto.getFechaModificacion());
            canalRequestDto.setFechaRegistro(detalleCanalRequestDto.getFechaModificacion());
            CanalResponseDto canalResponseDto = this.canalService.editCanal(id_canal, canalRequestDto);
            this.logger.warn("El canal ha sido actualizado");
            DetalleCanalResponseDto detalleCanal = this.canalService.getCanalById(id_canal);
            return new ResponseEntity((Object)detalleCanal, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

