/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleEvaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.EvaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleEvaluacionesResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.EvaluacionesResponseDto;
import com.dacrt.SBIABackend.entity.Evaluaciones;
import com.dacrt.SBIABackend.entity.Unidad;
import com.dacrt.SBIABackend.security.service.UsuarioService;
import com.dacrt.SBIABackend.service.EvaluacionesService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/evaluaciones"})
@CrossOrigin(origins={"*"})
public class EvaluacionesControler {
    @Autowired
    private EvaluacionesService evaluacionesService;
    @Autowired
    private UsuarioService usuarioService;
    Logger logger = LoggerFactory.getLogger(EvaluacionesControler.class);
    Date fechaActual = new Date();

    @Autowired
    public EvaluacionesControler(EvaluacionesService evaluacionesService) {
        this.evaluacionesService = evaluacionesService;
    }

    @GetMapping(value={"/usuarioUnidades/{nombreUsuario}/{continuar}/{idUnidad}/{nombreUnidad}"})
    public ResponseEntity<Set<Unidad>> buscarUnidades(@PathVariable String nombreUsuario, @PathVariable Integer continuar, @PathVariable Integer idUnidad, @PathVariable String nombreUnidad) {
        Set<Unidad> unidades = this.usuarioService.buscarUnidades(nombreUsuario);
        return new ResponseEntity(unidades, HttpStatus.OK);
    }

    @GetMapping(value={"/listar/{idUnidad}"})
    public ResponseEntity<List<DetalleEvaluacionesResponseDto>> buscarEvaluaciones(@PathVariable Integer idUnidad) {
        List<DetalleEvaluacionesResponseDto> detalleEvaluacionesResponseDto = this.evaluacionesService.buscarEvaluaciones(idUnidad);
        return new ResponseEntity(detalleEvaluacionesResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/cantidadEvaluaciones"})
    public ResponseEntity<?> countProcesos() {
        long cantidadEvaluaciones = this.evaluacionesService.countEvaluaciones();
        return new ResponseEntity((Object)cantidadEvaluaciones, HttpStatus.OK);
    }

    @GetMapping(value={"/cantidadEvaluacionesAbiertas/{idUnidad}"})
    public ResponseEntity<?> countEvaluacionesAbiertas(@PathVariable Integer idUnidad) {
        long cantidadEvaluaciones = this.evaluacionesService.countEvaluacionesAbiertas(idUnidad);
        return new ResponseEntity((Object)cantidadEvaluaciones, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> addEvaluaciones(@RequestBody EvaluacionesRequestDto evaluacionesRequestDto) {
        try {
            if (evaluacionesRequestDto.getIdMaestroEvaluacion() == 0 || evaluacionesRequestDto.getIdUnidad() == 0 || evaluacionesRequestDto.getFechaEvalua() == null || evaluacionesRequestDto.getId_procesamiento() == 0 || evaluacionesRequestDto.getProcesoRequerido() == 0 || evaluacionesRequestDto.getId_lineaoperacion() == 0 || evaluacionesRequestDto.getRto() == 0 || evaluacionesRequestDto.getMedidaRto() == 0 || evaluacionesRequestDto.getPromFact() == 0.0 || StringUtils.isBlank((CharSequence)evaluacionesRequestDto.getMcbo()) || evaluacionesRequestDto.getFactores().isEmpty()) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (evaluacionesRequestDto.getFechaEvalua().compareTo(this.fechaActual) > 0) {
                this.logger.warn("Error: La fecha de evaluaci\u00f3n no puede ser mayor que la fecha actual: " + evaluacionesRequestDto.getFechaEvalua());
                return new ResponseEntity((Object)new Mensaje("Error: La fecha de evaluaci\u00f3n no puede ser mayor que la fecha actual: " + evaluacionesRequestDto.getFechaEvalua()), HttpStatus.BAD_REQUEST);
            }
            Evaluaciones evaluaciones = this.evaluacionesService.addEvaluaciones(evaluacionesRequestDto);
            if (evaluaciones != null) {
                this.logger.info("Evaluaci\u00f3n agregada exit\u00f3samente id: " + evaluaciones.getIdEvaluacion());
            } else {
                this.logger.warn("Error: La Evaluaci\u00f3n no fue agregada id: " + evaluaciones.getIdEvaluacion());
            }
            DetalleEvaluacionesResponseDto evaluacionesResponseDto = new DetalleEvaluacionesResponseDto(null, 0, null, 0, null, null, 0, null, 0, null, null, 0, 0, null, 0, null, null, 0, null, this.fechaActual, null, this.fechaActual, this.fechaActual, null);
            return new ResponseEntity((Object)evaluacionesResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{idEvaluacion}"})
    public ResponseEntity<EvaluacionesResponseDto> editEvaluaciones(@RequestBody DetalleEvaluacionesRequestDto detalleEvaluacionesRequestDto, @PathVariable Integer idEvaluacion) {
        try {
            boolean valido = false;
            Evaluaciones evaluacion = new Evaluaciones();
            if (!this.evaluacionesService.existsById(idEvaluacion)) {
                this.logger.warn("No existe el id de evaluacion solicitado: " + idEvaluacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id de evaluacion solicitado: " + idEvaluacion), HttpStatus.NOT_FOUND);
            }
            if (detalleEvaluacionesRequestDto.getIdMaestroEvaluacion() == 0 || detalleEvaluacionesRequestDto.getIdUnidad() == 0 || detalleEvaluacionesRequestDto.getFechaEvalua() == null || detalleEvaluacionesRequestDto.getId_procesamiento() == 0 || detalleEvaluacionesRequestDto.getProcesoRequerido() == 0 || detalleEvaluacionesRequestDto.getId_lineaoperacion() == 0 || detalleEvaluacionesRequestDto.getRto() == 0 || detalleEvaluacionesRequestDto.getMedidaRto() == 0 || detalleEvaluacionesRequestDto.getPromFact() == 0.0 || StringUtils.isBlank((CharSequence)detalleEvaluacionesRequestDto.getMcbo())) {
                this.logger.warn("Los campos de la evaluaci\u00f3n son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos de la evaluaci\u00f3n son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            EvaluacionesResponseDto evaluacionesResponseDto = new EvaluacionesResponseDto();
            if (detalleEvaluacionesRequestDto.getFechaEvalua().compareTo(this.fechaActual) > 0) {
                this.logger.warn("Error: La fecha de evaluaci\u00f3n no puede ser mayor que la fecha actual: " + detalleEvaluacionesRequestDto.getFechaEvalua());
                return new ResponseEntity((Object)evaluacionesResponseDto, HttpStatus.BAD_REQUEST);
            }
            Evaluaciones evaluaciones = this.evaluacionesService.editEvaluaciones(detalleEvaluacionesRequestDto, idEvaluacion);
            if (evaluaciones != null) {
                this.logger.info("Evaluaci\u00f3n actualizada exit\u00f3samente id: " + evaluaciones.getIdEvaluacion());
                return new ResponseEntity((Object)evaluacionesResponseDto, HttpStatus.OK);
            }
            this.logger.warn("Error: La Evaluaci\u00f3n no fue agregada id: " + evaluaciones.getIdEvaluacion());
            return new ResponseEntity((Object)evaluacionesResponseDto, HttpStatus.OK);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/cerrar/{idEvaluacion}"})
    public ResponseEntity<?> cerrarEvaluaciones(@RequestBody EvaluacionesRequestDto evaluacionesRequestDto, @PathVariable Integer idEvaluacion) {
        try {
            if (!this.evaluacionesService.existsById(idEvaluacion)) {
                this.logger.warn("No existe el id de la evaluaci\u00f3n solicitada: " + idEvaluacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id de la evaluaci\u00f3n solicitada: " + idEvaluacion), HttpStatus.NOT_FOUND);
            }
            Evaluaciones evaluaciones = this.evaluacionesService.getEvaluacion(idEvaluacion);
            if (evaluaciones.getEstado() == 1 && this.evaluacionesService.validarUltimaEvaluacionAbierta(idEvaluacion, evaluaciones.getUnidad().getIdUnidad())) {
                this.logger.warn("No puede cerrar la evaluaci\u00f3n debido a que no es la \u00faltima evaluaci\u00f3n: " + idEvaluacion);
                return new ResponseEntity((Object)new Mensaje("No puede cerrar la evaluaci\u00f3n debido a que no es la \u00faltima evaluaci\u00f3n: " + idEvaluacion), HttpStatus.NOT_FOUND);
            }
            evaluaciones = this.evaluacionesService.cerrarEvaluaciones(evaluacionesRequestDto, idEvaluacion);
            if (evaluaciones != null) {
                this.logger.info("Evaluaci\u00f3n cerrada exit\u00f3samente id: " + evaluaciones.getIdEvaluacion());
            } else {
                this.logger.warn("Error: La Evaluaci\u00f3n no fue cerrada id: " + evaluaciones.getIdEvaluacion());
            }
            DetalleEvaluacionesResponseDto evaluacionesResponseDto = new DetalleEvaluacionesResponseDto(null, 0, null, 0, null, null, 0, null, 0, null, null, 0, 0, null, 0, null, null, 0, null, this.fechaActual, null, this.fechaActual, this.fechaActual, null);
            return new ResponseEntity((Object)evaluacionesResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @GetMapping(value={"/detail/{idEvaluacion}"})
    public ResponseEntity<?> getEvaluacion(@PathVariable Integer idEvaluacion) {
        try {
            if (!this.evaluacionesService.existsById(idEvaluacion)) {
                this.logger.warn("No existe el id de la evaluaci\u00f3n solicitada: " + idEvaluacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id de la evaluaci\u00f3n solicitada: " + idEvaluacion), HttpStatus.NOT_FOUND);
            }
            DetalleEvaluacionesResponseDto detalleEvaluacionesResponseDto = this.evaluacionesService.getEvaluacionesById(idEvaluacion);
            if (detalleEvaluacionesResponseDto != null) {
                return new ResponseEntity((Object)detalleEvaluacionesResponseDto, HttpStatus.OK);
            }
            this.logger.error("Error en la evaluaci\u00f3n: " + idEvaluacion);
            return new ResponseEntity((Object)new Mensaje("Error: No se encuentra la Evaluaci\u00f3n: " + idEvaluacion), HttpStatus.METHOD_NOT_ALLOWED);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

