/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleProcesoRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.ProcesoRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleProcesoResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.LineaOperacionResponseDto;
import com.dacrt.SBIABackend.entity.LineaOperacion;
import com.dacrt.SBIABackend.entity.Proceso;
import com.dacrt.SBIABackend.service.LineaOperacionService;
import com.dacrt.SBIABackend.service.ProcesoService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/procesos"})
@CrossOrigin(origins={"*"})
public class ProcesoControler {
    @Autowired
    ProcesoService procesoService;
    @Autowired
    LineaOperacionService lineaOperacionService;
    Logger logger = LoggerFactory.getLogger(ProcesoControler.class);
    Date fechaActual = new Date();

    @Autowired
    public ProcesoControler(ProcesoService procesoService) {
        this.procesoService = procesoService;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> addProceso(@RequestBody ProcesoRequestDto procesoRequestDto) {
        try {
            if (StringUtils.isBlank((CharSequence)procesoRequestDto.getIdProceso()) || StringUtils.isBlank((CharSequence)procesoRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)procesoRequestDto.getDescripcion()) || procesoRequestDto.getProcesoRemoto() == 0 || procesoRequestDto.getTipoProceso() == 0 || procesoRequestDto.getActivo() == 0 || procesoRequestDto.getIdLineaoperacion() == 0 || procesoRequestDto.getCanales().isEmpty()) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (procesoRequestDto.getIdProceso().length() > 8 || procesoRequestDto.getNombre().length() > 200 || procesoRequestDto.getDescripcion().length() > 400 || String.valueOf(procesoRequestDto.getActivo()).length() > 1 || String.valueOf(procesoRequestDto.getProcesoRemoto()).length() > 1 || String.valueOf(procesoRequestDto.getTipoProceso()).length() > 1 || String.valueOf(procesoRequestDto.getIdLineaoperacion()).length() > 10) {
                return new ResponseEntity((Object)new Mensaje("Varifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.procesoService.existsByidProceso(procesoRequestDto.getIdProceso())) {
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el c\u00f3digo del proceso"), HttpStatus.BAD_REQUEST);
            }
            if (this.procesoService.existsByNombre(procesoRequestDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el nombre del proceso"), HttpStatus.BAD_REQUEST);
            }
            Proceso proceso = new Proceso();
            proceso.setIdProceso(procesoRequestDto.getIdProceso());
            proceso.setNombre(procesoRequestDto.getNombre());
            proceso.setDescripcion(procesoRequestDto.getDescripcion());
            proceso.setProcesoRemoto(procesoRequestDto.getProcesoRemoto());
            proceso.setTipoProceso(procesoRequestDto.getTipoProceso());
            proceso.setActivo(procesoRequestDto.getActivo());
            proceso.setUsuario(procesoRequestDto.getUsuario());
            proceso.setFechaRegistro(procesoRequestDto.getFechaRegistro());
            proceso.setFechaModificacion(procesoRequestDto.getFechaModificacion());
            proceso.setCanales(procesoRequestDto.getCanales());
            LineaOperacion linea = new LineaOperacion();
            linea = this.lineaOperacionService.getLineaOperacion(procesoRequestDto.getIdLineaoperacion());
            proceso.setLineaOperacion(linea);
            this.procesoService.save(proceso);
            return new ResponseEntity((Object)new Mensaje("El proceso fue creado exitosamente"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @GetMapping(value={"/detail/{id_procesamiento}"})
    public ResponseEntity<DetalleProcesoResponseDto> getProceso(@PathVariable Integer id_procesamiento) {
        if (!this.procesoService.existsById(id_procesamiento)) {
            return new ResponseEntity((Object)new Mensaje("No existe el id del proceso solicitado"), HttpStatus.NOT_FOUND);
        }
        DetalleProcesoResponseDto detalleProcesoResponseDto = this.procesoService.getProcesoById(id_procesamiento);
        return new ResponseEntity((Object)detalleProcesoResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/obtenerLinea/{id_procesamiento}"})
    public ResponseEntity<LineaOperacionResponseDto> getLineaOperacion(@PathVariable Integer id_procesamiento) {
        if (!this.procesoService.existsById(id_procesamiento)) {
            return new ResponseEntity((Object)new Mensaje("No existe el id del proceso solicitado"), HttpStatus.NOT_FOUND);
        }
        LineaOperacionResponseDto lineaOperacionResponseDto = this.procesoService.getLineaOperacionProcesoById(id_procesamiento);
        return new ResponseEntity((Object)lineaOperacionResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleProcesoResponseDto>> getProcesos() {
        List<DetalleProcesoResponseDto> detalleProcesoResponseDtos = this.procesoService.getProcesos();
        return new ResponseEntity(detalleProcesoResponseDtos, HttpStatus.OK);
    }

    @GetMapping(value={"/cantidadProceso"})
    public ResponseEntity<?> countProcesos() {
        long cantidadProcesos = this.procesoService.countProceso();
        return new ResponseEntity((Object)cantidadProcesos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_procesamiento}"})
    public ResponseEntity<?> deleteProceso(DetalleProcesoRequestDto detalleProcesoRequestDto, @PathVariable Integer id_procesamiento) {
        try {
            if (!this.procesoService.existsById(id_procesamiento)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id del procesamiento solicitado"), HttpStatus.NOT_FOUND);
            }
            Proceso proceso = this.procesoService.getProceso(id_procesamiento);
            int valor = proceso.getActivo() == 1 ? 2 : 1;
            proceso.setActivo(valor);
            proceso.setUsuario(proceso.getUsuario());
            proceso.setFechaModificacion(this.fechaActual);
            this.procesoService.save(proceso);
            if (proceso.getActivo() == 1) {
                return new ResponseEntity((Object)new Mensaje("El proceso con id " + id_procesamiento + " fue activado"), HttpStatus.OK);
            }
            return new ResponseEntity((Object)new Mensaje("El proceso con id " + id_procesamiento + " fue desactivado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_procesamiento}"})
    public ResponseEntity<DetalleProcesoResponseDto> editProceso(@RequestBody DetalleProcesoRequestDto detalleProcesoRequestDto, @PathVariable(value="id_procesamiento") Integer id_procesamiento) {
        try {
            if (!this.procesoService.existsById(id_procesamiento)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id del proceso solicitado"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleProcesoRequestDto.getIdProceso()) || StringUtils.isBlank((CharSequence)detalleProcesoRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)detalleProcesoRequestDto.getDescripcion()) || detalleProcesoRequestDto.getActivo() == 0 || detalleProcesoRequestDto.getProcesoRemoto() == 0 || detalleProcesoRequestDto.getTipoProceso() == 0 || detalleProcesoRequestDto.getIdLineaoperacion() == 0 || detalleProcesoRequestDto.getCanales().isEmpty()) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleProcesoRequestDto.getIdProceso().length() > 8 || detalleProcesoRequestDto.getNombre().length() > 200 || detalleProcesoRequestDto.getDescripcion().length() > 400 || String.valueOf(detalleProcesoRequestDto.getActivo()).length() > 1 || String.valueOf(detalleProcesoRequestDto.getProcesoRemoto()).length() > 1 || String.valueOf(detalleProcesoRequestDto.getTipoProceso()).length() > 1 || String.valueOf(detalleProcesoRequestDto.getIdLineaoperacion()).length() > 10) {
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.procesoService.existsByNombre(detalleProcesoRequestDto.getNombre()) && this.procesoService.getByNombre(detalleProcesoRequestDto.getNombre()).get().getId_procesamiento() != id_procesamiento.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El nombre del proceso ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (this.procesoService.existsByidProceso(detalleProcesoRequestDto.getIdProceso()) && this.procesoService.getByidProceso(detalleProcesoRequestDto.getIdProceso()).get().getId_procesamiento() != id_procesamiento.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El c\u00f3digo del Proceso ya existe"), HttpStatus.BAD_REQUEST);
            }
            DetalleProcesoRequestDto detalleProcesoRequestDto2 = new DetalleProcesoRequestDto();
            detalleProcesoRequestDto2.setId_procesamiento(detalleProcesoRequestDto.getId_procesamiento());
            detalleProcesoRequestDto2.setIdProceso(detalleProcesoRequestDto.getIdProceso());
            detalleProcesoRequestDto2.setNombre(detalleProcesoRequestDto.getNombre());
            detalleProcesoRequestDto2.setDescripcion(detalleProcesoRequestDto.getDescripcion());
            detalleProcesoRequestDto2.setActivo(detalleProcesoRequestDto.getActivo());
            detalleProcesoRequestDto2.setProcesoRemoto(detalleProcesoRequestDto.getProcesoRemoto());
            detalleProcesoRequestDto2.setTipoProceso(detalleProcesoRequestDto.getTipoProceso());
            detalleProcesoRequestDto2.setIdLineaoperacion(detalleProcesoRequestDto.getIdLineaoperacion());
            detalleProcesoRequestDto2.setUsuario(detalleProcesoRequestDto.getUsuario());
            detalleProcesoRequestDto2.setFechaModificacion(detalleProcesoRequestDto.getFechaModificacion());
            detalleProcesoRequestDto2.setFechaRegistro(detalleProcesoRequestDto.getFechaModificacion());
            detalleProcesoRequestDto2.setCanales(detalleProcesoRequestDto.getCanales());
            this.procesoService.editProceso(id_procesamiento, detalleProcesoRequestDto2);
            DetalleProcesoResponseDto detalleProceso = this.procesoService.getProcesoById(id_procesamiento);
            return new ResponseEntity((Object)detalleProceso, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

