/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.RecursosDto;
import com.dacrt.SBIABackend.entity.Recursos;
import com.dacrt.SBIABackend.service.RecursosService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recursos"})
@CrossOrigin(origins={"*"})
public class RecursosController {
    @Autowired
    RecursosService recursosService;
    Logger logger = LoggerFactory.getLogger(RecursosController.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<Recursos>> list() {
        List<Recursos> list = this.recursosService.list();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_recursos}"})
    public ResponseEntity<Recursos> getById(@PathVariable(value="id_recursos") Long id_recursos) {
        if (!this.recursosService.existsById(id_recursos)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Recurso"), HttpStatus.NOT_FOUND);
        }
        Recursos recursos = this.recursosService.getOne(id_recursos).get();
        return new ResponseEntity((Object)recursos, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<Recursos> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.recursosService.existsByNombre(nombre)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Recurso"), HttpStatus.NOT_FOUND);
        }
        Recursos recursos = this.recursosService.getByNombre(nombre).get();
        return new ResponseEntity((Object)recursos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody RecursosDto recursosDto) {
        try {
            if (StringUtils.isBlank((CharSequence)recursosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Recurso es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            if (this.recursosService.existsByNombre(recursosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Recurso ya existe"), HttpStatus.BAD_REQUEST);
            }
            Recursos recursos = new Recursos(recursosDto.getNombre(), recursosDto.getDescripcion(), recursosDto.getTipoRecurso(), recursosDto.getCantidadRecurso(), recursosDto.getRecurso30m(), recursosDto.getRecurso1h(), recursosDto.getRecurso4h(), recursosDto.getRecurso8h(), recursosDto.getRecurso24h(), recursosDto.getRecurso48h(), recursosDto.getRecurso72h(), recursosDto.getRecurso96h(), recursosDto.getRecurso120h(), recursosDto.getRecurso144h(), recursosDto.getUsuario(), recursosDto.getFechaRegistro(), recursosDto.getFechaModificacion());
            this.recursosService.save(recursos);
            return new ResponseEntity((Object)new Mensaje("Recurso creado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_recursos}"})
    public ResponseEntity<?> update(@PathVariable(value="id_recursos") Long id_recursos, @RequestBody RecursosDto recursosDto) {
        try {
            if (!this.recursosService.existsById(id_recursos)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Recurso"), HttpStatus.NOT_FOUND);
            }
            if (this.recursosService.existsByNombre(recursosDto.getNombre()) && this.recursosService.getByNombre(recursosDto.getNombre()).get().getId_recurso() != id_recursos) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Recurso ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (StringUtils.isBlank((CharSequence)recursosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Recurso es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            Recursos recursos = this.recursosService.getOne(id_recursos).get();
            recursos.setNombre(recursosDto.getNombre());
            recursos.setDescripcion(recursosDto.getDescripcion());
            recursos.setCantidadRecurso(recursosDto.getCantidadRecurso());
            recursos.setTipoRecurso(recursosDto.getTipoRecurso());
            recursos.setCantidadRecurso(recursosDto.getCantidadRecurso());
            recursos.setRecurso30m(recursosDto.getRecurso30m());
            recursos.setRecurso1h(recursosDto.getRecurso1h());
            recursos.setRecurso4h(recursosDto.getRecurso4h());
            recursos.setRecurso8h(recursosDto.getRecurso8h());
            recursos.setRecurso24h(recursosDto.getRecurso24h());
            recursos.setRecurso48h(recursosDto.getRecurso48h());
            recursos.setRecurso72h(recursosDto.getRecurso72h());
            recursos.setRecurso96h(recursosDto.getRecurso96h());
            recursos.setRecurso120h(recursosDto.getRecurso120h());
            recursos.setRecurso144h(recursosDto.getRecurso144h());
            recursos.setUsuario(recursosDto.getUsuario());
            recursos.setFechaModificacion(recursosDto.getFechaModificacion());
            recursos.setFechaRegistro(recursosDto.getFechaRegistro());
            this.recursosService.save(recursos);
            return new ResponseEntity((Object)new Mensaje("Recurso actualizado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_recursos}"})
    public ResponseEntity<?> delete(@PathVariable(value="id_recursos") Long id_recursos) {
        try {
            if (!this.recursosService.existsById(id_recursos)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Recurso"), HttpStatus.NOT_FOUND);
            }
            this.recursosService.delete(id_recursos);
            return new ResponseEntity((Object)new Mensaje("Recurso eliminado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

