/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.RegistrosVitalesDto;
import com.dacrt.SBIABackend.entity.RegistrosVitales;
import com.dacrt.SBIABackend.service.RegistrosVitalesService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/registrosvitales"})
@CrossOrigin(origins={"*"})
public class RegistrosVitalesControler {
    @Autowired
    RegistrosVitalesService registrosvitalesService;
    Logger logger = LoggerFactory.getLogger(RegistrosVitalesControler.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<RegistrosVitales>> list() {
        List<RegistrosVitales> list = this.registrosvitalesService.list();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_registrovital}"})
    public ResponseEntity<RegistrosVitales> getById(@PathVariable(value="id_registrovital") Long id_registrovital) {
        if (!this.registrosvitalesService.existsById(id_registrovital)) {
            return new ResponseEntity((Object)new Mensaje("No existe el registro vital solicitado"), HttpStatus.NOT_FOUND);
        }
        RegistrosVitales registrosvitales = this.registrosvitalesService.getOne(id_registrovital).get();
        return new ResponseEntity((Object)registrosvitales, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<RegistrosVitales> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.registrosvitalesService.existsByNombre(nombre)) {
            return new ResponseEntity((Object)new Mensaje("No existe el nombre del registro vital solicitado"), HttpStatus.NOT_FOUND);
        }
        RegistrosVitales registrosvitales = this.registrosvitalesService.getByNombre(nombre).get();
        return new ResponseEntity((Object)registrosvitales, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody RegistrosVitalesDto registrosvitalesDto) {
        try {
            if (StringUtils.isBlank((CharSequence)registrosvitalesDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("el nombre del registro vital es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            if (this.registrosvitalesService.existsByNombre(registrosvitalesDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("ese nombre del registro vital ya existe"), HttpStatus.BAD_REQUEST);
            }
            RegistrosVitales registrosvitales = new RegistrosVitales(registrosvitalesDto.getNombre(), registrosvitalesDto.getDescripcion(), registrosvitalesDto.getUbicacion(), registrosvitalesDto.getTipoRegistroVital(), registrosvitalesDto.getInd_resguardo(), registrosvitalesDto.getUsuario(), registrosvitalesDto.getFechaRegistro(), registrosvitalesDto.getFechaModificacion());
            this.registrosvitalesService.save(registrosvitales);
            return new ResponseEntity((Object)new Mensaje("Registro Vital creado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_registrovital}"})
    public ResponseEntity<?> update(@PathVariable(value="id_registrovital") Long id_registrovital, @RequestBody RegistrosVitalesDto registrosvitalesDto) {
        try {
            if (!this.registrosvitalesService.existsById(id_registrovital)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Registro Vital"), HttpStatus.NOT_FOUND);
            }
            if (this.registrosvitalesService.existsByNombre(registrosvitalesDto.getNombre()) && this.registrosvitalesService.getByNombre(registrosvitalesDto.getNombre()).get().getId_registrosvitales() != id_registrovital) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Registro Vital ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (StringUtils.isBlank((CharSequence)registrosvitalesDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("el nombre del Registro Vital es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            RegistrosVitales registrosvitales = this.registrosvitalesService.getOne(id_registrovital).get();
            registrosvitales.setNombre(registrosvitalesDto.getNombre());
            registrosvitales.setDescripcion(registrosvitalesDto.getDescripcion());
            registrosvitales.setUbicacion(registrosvitalesDto.getUbicacion());
            registrosvitales.setTipoRegistroVital(registrosvitalesDto.getTipoRegistroVital());
            registrosvitales.setInd_resguardo(registrosvitalesDto.getInd_resguardo());
            registrosvitales.setUsuario(registrosvitalesDto.getUsuario());
            registrosvitales.setFechaModificacion(registrosvitalesDto.getFechaModificacion());
            registrosvitales.setFechaRegistro(registrosvitalesDto.getFechaRegistro());
            this.registrosvitalesService.save(registrosvitales);
            return new ResponseEntity((Object)new Mensaje("Registro Vital actualizado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @DeleteMapping(value={"/delete/{id_registrovital}"})
    public ResponseEntity<?> delete(@PathVariable(value="id_registrovital") Long id_registrovital) {
        try {
            if (!this.registrosvitalesService.existsById(id_registrovital)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Registro Vital"), HttpStatus.NOT_FOUND);
            }
            this.registrosvitalesService.delete(id_registrovital);
            return new ResponseEntity((Object)new Mensaje("Registro Vital eliminado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

