/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.exception;

import com.dacrt.SBIABackend.dto.Mensaje;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.NOT_FOUND)
public class ResourceNotFoundException
extends RuntimeException {
    private String resourceName;
    private String fileName;
    private Object fieldValue;

    public ResourceNotFoundException() {
    }

    public ResourceNotFoundException(String resourceName, String fileName, Object fieldValue) {
        super(String.format("%s no fue encontrado con: %s='%s'", resourceName, fileName, fieldValue));
        this.resourceName = resourceName;
        this.fileName = fileName;
        this.fieldValue = fieldValue;
    }

    public Mensaje ResourceNotFoundException(String resourceName, String fileName, Object fieldValue) {
        this.resourceName = resourceName;
        this.fileName = fileName;
        this.fieldValue = fieldValue;
        Mensaje mensaje = new Mensaje(String.format("%s no fue encontrado con: %s='%s'", resourceName, fileName, fieldValue));
        return mensaje;
    }

    public Mensaje ResourceNotFoundExceptionList(String resourceName) {
        this.resourceName = resourceName;
        Mensaje mensaje = new Mensaje(String.format("No hay registros de %s en el sistema", resourceName));
        return mensaje;
    }
}

