/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security;

import com.dacrt.SBIABackend.security.jwt.JwtEntryPoint;
import com.dacrt.SBIABackend.security.jwt.JwtTokenFilter;
import com.dacrt.SBIABackend.security.service.UsuarioDetailServiceImpl;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class MainSecurity {
    @Autowired
    UsuarioDetailServiceImpl userDetailsServiceImpl;
    @Autowired
    JwtEntryPoint jwtEntryPoint;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    JwtTokenFilter jwtTokenFilter;
    AuthenticationManager authenticationManager;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder builder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        builder.userDetailsService((UserDetailsService)this.userDetailsServiceImpl).passwordEncoder(this.passwordEncoder);
        this.authenticationManager = (AuthenticationManager)builder.build();
        http.authenticationManager(this.authenticationManager);
        http.csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        });
        http.cors(Customizer.withDefaults());
        http.sessionManagement(session -> {
            SessionManagementConfigurer sessionManagementConfigurer = session.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        });
        http.authorizeHttpRequests(auth -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.antMatchers(new String[]{"/auth/**", "/email-password/**", "/v2/api-docs/**", "/swagger-ui/**", "/swagger-resources/**", "/configuration/**"})).permitAll().anyRequest()).authenticated();
        });
        http.exceptionHandling(exc -> {
            ExceptionHandlingConfigurer exceptionHandlingConfigurer = exc.authenticationEntryPoint((AuthenticationEntryPoint)this.jwtEntryPoint);
        });
        http.addFilterBefore((Filter)this.jwtTokenFilter, UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }
}

