/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.security.dto.AccesoDto;
import com.dacrt.SBIABackend.security.dto.ComprobadorAcceso;
import com.dacrt.SBIABackend.security.dto.EstadoAutorizacion;
import com.dacrt.SBIABackend.security.dto.JwtDto;
import com.dacrt.SBIABackend.security.dto.LoginUsuario;
import com.dacrt.SBIABackend.security.dto.NuevoUsuario;
import com.dacrt.SBIABackend.security.dto.RolAccesoDto;
import com.dacrt.SBIABackend.security.entity.Rol;
import com.dacrt.SBIABackend.security.entity.RolOpcionDeBIA;
import com.dacrt.SBIABackend.security.entity.Usuario;
import com.dacrt.SBIABackend.security.enums.RolNombre;
import com.dacrt.SBIABackend.security.jwt.JwtProvider;
import com.dacrt.SBIABackend.security.service.RolService;
import com.dacrt.SBIABackend.security.service.UsuarioService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
@CrossOrigin(origins={"*"})
public class AuthControler {
    @Autowired
    PasswordEncoder passworEncoder;
    @Autowired
    AuthenticationManager autheticationManager;
    @Autowired
    UsuarioService usuarioService;
    @Autowired
    RolService rolService;
    @Autowired
    JwtProvider jwtProvider;

    @PostMapping(value={"/nuevo"})
    public ResponseEntity<?> nuevo(@Valid @RequestBody NuevoUsuario nuevoUsuario, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResponseEntity((Object)new Mensaje("Campos mal puestos o meail inv\u00e1lido"), HttpStatus.BAD_REQUEST);
        }
        if (this.usuarioService.existsByUsuario(nuevoUsuario.getUsuario())) {
            return new ResponseEntity((Object)new Mensaje("Ese nombre ya existe"), HttpStatus.BAD_REQUEST);
        }
        if (this.usuarioService.existsByEmail(nuevoUsuario.getEmail())) {
            return new ResponseEntity((Object)new Mensaje("Ese email ya existe"), HttpStatus.BAD_REQUEST);
        }
        Usuario usuario = new Usuario(nuevoUsuario.getNombre(), nuevoUsuario.getUsuario(), nuevoUsuario.getEmail(), this.passworEncoder.encode((CharSequence)nuevoUsuario.getPassword()), nuevoUsuario.getUnidad());
        HashSet<Rol> roles = new HashSet<Rol>();
        roles.add(this.rolService.getByRolNombre(RolNombre.ROLE_USER.name()).get());
        if (nuevoUsuario.getRoles().contains("admin")) {
            roles.add(this.rolService.getByRolNombre(RolNombre.ROLE_ADMIN.name()).get());
        }
        usuario.setRoles(roles);
        this.usuarioService.save(usuario);
        return new ResponseEntity((Object)new Mensaje("Usuario Guardado"), HttpStatus.CREATED);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<JwtDto> login(@Valid @RequestBody LoginUsuario loginUsuario, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResponseEntity((Object)new Mensaje("Campos mal puestos o meail inv\u00e1lido"), HttpStatus.BAD_REQUEST);
        }
        Authentication authentication = this.autheticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginUsuario.getUsuario(), (Object)loginUsuario.getPassword()));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String jwt = this.jwtProvider.generateToken(authentication);
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        JwtDto jwtDto = new JwtDto(jwt, userDetails.getUsername(), userDetails.getAuthorities());
        return new ResponseEntity((Object)jwtDto, HttpStatus.OK);
    }

    @PostMapping(value={"/autorizacion"})
    public ResponseEntity<EstadoAutorizacion> autorizacion(@Valid @RequestBody ComprobadorAcceso comprobadorAcceso, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResponseEntity((Object)new Mensaje("Campos mal puestos"), HttpStatus.BAD_REQUEST);
        }
        EstadoAutorizacion estadoAutorizacion = new EstadoAutorizacion();
        if (comprobadorAcceso.getIdentificadorPagina().equals("PRUEBA")) {
            estadoAutorizacion.setEstaAutorizado("SI");
            estadoAutorizacion.setTipoAutorizacion("EDICION");
        } else {
            estadoAutorizacion.setEstaAutorizado("NO");
            estadoAutorizacion.setTipoAutorizacion("NINGUNA");
        }
        return new ResponseEntity((Object)estadoAutorizacion, HttpStatus.OK);
    }

    @PostMapping(value={"/conectarol"})
    public ResponseEntity<AccesoDto> conectarol(@Valid @RequestBody RolAccesoDto rolAccesoDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResponseEntity((Object)new Mensaje("Campos mal puestos"), HttpStatus.BAD_REQUEST);
        }
        ArrayList<String> accesos = new ArrayList<String>();
        Set<RolOpcionDeBIA> rolesOpcionesDeBIA = this.rolService.buscarOpcionesDeRol(rolAccesoDto.getRol());
        for (RolOpcionDeBIA rolOpcionDeBIA : rolesOpcionesDeBIA) {
            accesos.add(String.valueOf(rolOpcionDeBIA.getOpcionDeBIA().getOpcion()) + "|" + rolOpcionDeBIA.getModo());
        }
        AccesoDto accesoDto = new AccesoDto();
        accesoDto.setAccesos(accesos);
        return new ResponseEntity((Object)accesoDto, HttpStatus.OK);
    }
}

