/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.jwt;

import com.dacrt.SBIABackend.security.entity.UsuarioPrincipal;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class JwtProvider {
    private static final Logger logger = LoggerFactory.getLogger(JwtProvider.class);
    @Value(value="${jwt.secret}")
    private String secret;
    @Value(value="${jwt.expiration}")
    private int expiration;

    public String generateToken(Authentication authentication) {
        UsuarioPrincipal usuarioPrincipal = (UsuarioPrincipal)authentication.getPrincipal();
        return Jwts.builder().setSubject(usuarioPrincipal.getUsername()).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)(this.expiration * 1000))).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public String getUsuarioFromToken(String token) {
        return ((Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token);
            return true;
        }
        catch (MalformedJwtException e) {
            logger.error("token mal formado");
        }
        catch (UnsupportedJwtException e) {
            logger.error("token no soportado" + e.getMessage());
        }
        catch (ExpiredJwtException e) {
            logger.error("token expirado");
        }
        catch (IllegalArgumentException e) {
            logger.error("token vacio");
        }
        catch (SignatureException e) {
            logger.error("fail en la firma");
        }
        return false;
    }
}

