/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.jwt;

import com.dacrt.SBIABackend.security.jwt.JwtProvider;
import com.dacrt.SBIABackend.security.service.UsuarioDetailServiceImpl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtTokenFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenFilter.class);
    @Autowired
    JwtProvider jwtProvider;
    @Autowired
    UsuarioDetailServiceImpl userDetailsService;

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) throws ServletException, IOException {
        try {
            String token = this.getToken(req);
            if (token != null && this.jwtProvider.validateToken(token)) {
                String nombreUsuario = this.jwtProvider.getUsuarioFromToken(token);
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(nombreUsuario);
                UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            }
        }
        catch (Exception e) {
            logger.error("fail en el m\u00e9todo doFilter " + e.getMessage());
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private String getToken(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer")) {
            return header.replace("Bearer ", "");
        }
        return null;
    }
}

