/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.DetalleComponentedetiDto;
import com.dacrt.SBIABackend.entity.Componentesdeti;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.repository.ComponentesdetiRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ComponentesdetiService {
    @Autowired
    ComponentesdetiRepository componentesdetiRepository;
    @Autowired
    ParametrosRepository parametrosRepository;

    public List<DetalleComponentedetiDto> list() {
        ArrayList<DetalleComponentedetiDto> listaComponentes = new ArrayList<DetalleComponentedetiDto>();
        String boton = "";
        List componentesDeTi = StreamSupport.stream(this.componentesdetiRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Componentesdeti componente : componentesDeTi) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(componente.getActivo()));
            Optional<Parametros> deTipoComponente = this.parametrosRepository.findByIdtablaAndValor("TIPOCOMPONENTE", String.valueOf(componente.getActivo()));
            int id_tipocomponente = Integer.parseInt(deTipoComponente.get().getValor());
            String tipoComponente = deTipoComponente.get().getNombre();
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String estatus = deEstatus.get().getNombre();
            boton = id_estatus == 1 ? "Desactivar" : "Activar";
            DetalleComponentedetiDto detalleComponente = new DetalleComponentedetiDto(componente.getId_componentedeti(), componente.getNombre(), componente.getDescripcion(), id_tipocomponente, tipoComponente, componente.getUbicacion(), id_estatus, estatus, boton, componente.getUsuario(), componente.getFechaRegistro(), componente.getFechaModificacion());
            listaComponentes.add(detalleComponente);
        }
        return listaComponentes;
    }

    public DetalleComponentedetiDto getComponenteById(Integer id_componentedeti) {
        String boton = "";
        Componentesdeti componenteDeTi = this.getComponentedeti(id_componentedeti);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(componenteDeTi.getActivo()));
        Optional<Parametros> deTipoComponente = this.parametrosRepository.findByIdtablaAndValor("TIPOCOMPONENTE", String.valueOf(componenteDeTi.getTipoComponente()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        int id_tipocomponente = Integer.parseInt(deTipoComponente.get().getValor());
        String tipoComponente = deTipoComponente.get().getNombre();
        DetalleComponentedetiDto detalleComponentedetiDto = new DetalleComponentedetiDto(componenteDeTi.getId_componentedeti(), componenteDeTi.getNombre(), componenteDeTi.getDescripcion(), id_tipocomponente, tipoComponente, componenteDeTi.getUbicacion(), id_estatus, estatus, boton, componenteDeTi.getUsuario(), componenteDeTi.getFechaRegistro(), componenteDeTi.getFechaModificacion());
        return detalleComponentedetiDto;
    }

    public Componentesdeti getComponentedeti(Integer id_componentedeti) {
        Componentesdeti componentesdeti = (Componentesdeti)this.componentesdetiRepository.findById(id_componentedeti).orElseThrow(() -> new IllegalArgumentException("No se encuentra canal con id: " + id_componentedeti));
        return componentesdeti;
    }

    public Optional<Componentesdeti> getOne(Integer id_componentedeti) {
        return this.componentesdetiRepository.findById(id_componentedeti);
    }

    public Optional<Componentesdeti> getByNombre(String nombre) {
        return this.componentesdetiRepository.findByNombre(nombre);
    }

    public void save(Componentesdeti componentesdeti) {
        this.componentesdetiRepository.save(componentesdeti);
    }

    public void delete(Integer id_componentedeti) {
        this.componentesdetiRepository.deleteById(id_componentedeti);
    }

    public boolean existsById(Integer id_componentedeti) {
        return this.componentesdetiRepository.existsById(id_componentedeti);
    }

    public boolean existsByNombre(String nombre) {
        return this.componentesdetiRepository.existsByNombre(nombre);
    }

    public long countComponentes() {
        return this.componentesdetiRepository.count();
    }
}

