/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.Mapper;
import com.dacrt.SBIABackend.dto.requestDto.LineaOperacionRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleLineaOperacionResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.LineaOperacionResponseDto;
import com.dacrt.SBIABackend.entity.LineaOperacion;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.repository.LineaOperacionRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.service.LineaOperacionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LineaOperacionServiceImpl
implements LineaOperacionService {
    @Autowired
    private LineaOperacionRepository lineaOperacionRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    Date fechaActual = new Date();

    @Autowired
    public LineaOperacionServiceImpl(LineaOperacionRepository lineaOperacionRepository) {
        this.lineaOperacionRepository = lineaOperacionRepository;
    }

    @Override
    @Transactional
    public LineaOperacionResponseDto addLineaOperacion(LineaOperacionRequestDto lineaOperacionRequestDto) {
        LineaOperacion lineaOperacion = new LineaOperacion();
        lineaOperacion.setNombre(lineaOperacionRequestDto.getNombre());
        lineaOperacion.setActivo(lineaOperacionRequestDto.getActivo());
        lineaOperacion.setUsuario(lineaOperacionRequestDto.getUsuario());
        lineaOperacion.setFechaRegistro(lineaOperacionRequestDto.getFechaRegistro());
        lineaOperacion.setFechaModificacion(lineaOperacionRequestDto.getFechaModificacion());
        return Mapper.lineatolineaResponseDto((LineaOperacion)this.lineaOperacionRepository.save(lineaOperacion));
    }

    @Override
    public LineaOperacion getLineaOperacion(Integer id_lineaoperacion) {
        LineaOperacion lineaOperacion = this.lineaOperacionRepository.findById(id_lineaoperacion).orElseThrow(() -> new IllegalArgumentException("No se encuentra la l\u00ednea de operaci\u00f3n con id: " + id_lineaoperacion));
        return lineaOperacion;
    }

    @Override
    public LineaOperacionResponseDto deleteLineaOperacion(Integer id_lineaoperacion, LineaOperacionRequestDto lineaOperacionRequestDto) {
        LineaOperacion lineaOperacion = this.getLineaOperacion(id_lineaoperacion);
        lineaOperacion.setNombre(lineaOperacionRequestDto.getNombre());
        lineaOperacion.setUsuario(lineaOperacionRequestDto.getUsuario());
        lineaOperacion.setActivo(lineaOperacionRequestDto.getActivo());
        lineaOperacion.setFechaRegistro(lineaOperacionRequestDto.getFechaRegistro());
        lineaOperacion.setFechaModificacion(lineaOperacionRequestDto.getFechaModificacion());
        return Mapper.lineatolineaResponseDto((LineaOperacion)this.lineaOperacionRepository.save(lineaOperacion));
    }

    @Override
    public LineaOperacionResponseDto editLineaOperacion(Integer id_lineaoperacion, LineaOperacionRequestDto lineaOperacionRequestDto) {
        LineaOperacion lineaOperacion = this.getLineaOperacion(id_lineaoperacion);
        lineaOperacion.setNombre(lineaOperacionRequestDto.getNombre());
        lineaOperacion.setActivo(lineaOperacionRequestDto.getActivo());
        lineaOperacion.setFechaModificacion(this.fechaActual);
        lineaOperacion.setUsuario(lineaOperacionRequestDto.getUsuario());
        return Mapper.lineatolineaResponseDto((LineaOperacion)this.lineaOperacionRepository.save(lineaOperacion));
    }

    @Override
    public Optional<LineaOperacion> findByNombre(LineaOperacionRequestDto lineaOperacionRequestDto) {
        return this.lineaOperacionRepository.findByNombre(lineaOperacionRequestDto.getNombre());
    }

    @Override
    public boolean existsByNombre(LineaOperacionRequestDto lineaOperacionRequestDto) {
        return this.lineaOperacionRepository.existsByNombre(lineaOperacionRequestDto.getNombre());
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.lineaOperacionRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsById(Integer id_lineaoperacion) {
        return this.lineaOperacionRepository.existsById(id_lineaoperacion);
    }

    @Override
    public DetalleLineaOperacionResponseDto getLineaOperacionById(Integer id_lineaoperacion) {
        String boton = "";
        LineaOperacion lineaOperacion = this.getLineaOperacion(id_lineaoperacion);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(lineaOperacion.getActivo()));
        String estatus = deEstatus.get().getNombre();
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        DetalleLineaOperacionResponseDto detalleLineaOperacionResponseDto = new DetalleLineaOperacionResponseDto(lineaOperacion.getId_lineaoperacion(), lineaOperacion.getNombre(), id_estatus, estatus, boton, lineaOperacion.getUsuario(), lineaOperacion.getFechaRegistro(), lineaOperacion.getFechaModificacion());
        return detalleLineaOperacionResponseDto;
    }

    @Override
    public List<DetalleLineaOperacionResponseDto> getLineaOperaciones() {
        ArrayList<DetalleLineaOperacionResponseDto> listaDetalleLineaOperacion = new ArrayList<DetalleLineaOperacionResponseDto>();
        String boton = "";
        List lineaOperaciones = StreamSupport.stream(this.lineaOperacionRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (LineaOperacion lineaOperacion : lineaOperaciones) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(lineaOperacion.getActivo()));
            String estatus = deEstatus.get().getNombre();
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            boton = id_estatus == 1 ? "Desactivar" : "Activar";
            DetalleLineaOperacionResponseDto detalleLineaOperacion = new DetalleLineaOperacionResponseDto(lineaOperacion.getId_lineaoperacion(), lineaOperacion.getNombre(), id_estatus, estatus, boton, lineaOperacion.getUsuario(), lineaOperacion.getFechaRegistro(), lineaOperacion.getFechaModificacion());
            listaDetalleLineaOperacion.add(detalleLineaOperacion);
        }
        return listaDetalleLineaOperacion;
    }

    @Override
    public List<DetalleLineaOperacionResponseDto> getLineaOperacionesActivos() {
        ArrayList<DetalleLineaOperacionResponseDto> listaDetalleLineaOperacion = new ArrayList<DetalleLineaOperacionResponseDto>();
        String boton = "";
        List lineaOperaciones = StreamSupport.stream(this.lineaOperacionRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (LineaOperacion lineaOperacion : lineaOperaciones) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(lineaOperacion.getActivo()));
            String estatus = deEstatus.get().getNombre();
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            if (id_estatus != 1) continue;
            DetalleLineaOperacionResponseDto detalleLineaOperacion = new DetalleLineaOperacionResponseDto(lineaOperacion.getId_lineaoperacion(), lineaOperacion.getNombre(), id_estatus, estatus, boton, lineaOperacion.getUsuario(), lineaOperacion.getFechaRegistro(), lineaOperacion.getFechaModificacion());
            listaDetalleLineaOperacion.add(detalleLineaOperacion);
        }
        return listaDetalleLineaOperacion;
    }

    @Override
    public Optional<LineaOperacion> getByNombre(String nombre) {
        return this.lineaOperacionRepository.findByNombre(nombre);
    }

    @Override
    public Optional<LineaOperacion> getOne(int id_lineaoperacion) {
        return this.lineaOperacionRepository.findById(id_lineaoperacion);
    }
}

