/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.requestDto.MaestroevaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleMaestroevaluacionesResponseDto;
import com.dacrt.SBIABackend.entity.Maestroevaluacion;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.Unidad;
import com.dacrt.SBIABackend.repository.MaestroevaluacionesRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.UnidadRepository;
import com.dacrt.SBIABackend.service.MaestroevaluacionesService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class MaestroevaluacionesServiceImpl
implements MaestroevaluacionesService {
    @Autowired
    private MaestroevaluacionesRepository maestroEvaluacionesRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    @Autowired
    private UnidadRepository unidadRepository;
    Date fechaActual = new Date();

    @Autowired
    public MaestroevaluacionesServiceImpl(MaestroevaluacionesRepository maestroEvaluacionesRepository) {
        this.maestroEvaluacionesRepository = maestroEvaluacionesRepository;
    }

    @Override
    @Transactional
    public Maestroevaluacion addMaestro(MaestroevaluacionesRequestDto maestroEvaluacionesRequestDto) {
        Maestroevaluacion maestroEvaluaciones = new Maestroevaluacion();
        maestroEvaluaciones.setNombreEvaluacion(maestroEvaluacionesRequestDto.getNombreEvaluacion());
        maestroEvaluaciones.setDescripcionEvalua(maestroEvaluacionesRequestDto.getDescripcionEvalua());
        maestroEvaluaciones.setFechaApertura(maestroEvaluacionesRequestDto.getFechaApertura());
        maestroEvaluaciones.setFechaCorte(maestroEvaluacionesRequestDto.getFechaCorte());
        maestroEvaluaciones.setFechaCierre(maestroEvaluacionesRequestDto.getFechaCierre());
        maestroEvaluaciones.setActivo(maestroEvaluacionesRequestDto.getActivo());
        maestroEvaluaciones.setUsuario(maestroEvaluacionesRequestDto.getUsuario());
        maestroEvaluaciones.setFechaRegistro(maestroEvaluacionesRequestDto.getFechaRegistro());
        maestroEvaluaciones.setFechaModificacion(maestroEvaluacionesRequestDto.getFechaModificacion());
        Unidad unidad = new Unidad();
        Optional<Unidad> unidad2 = this.unidadRepository.findById(maestroEvaluacionesRequestDto.getIdUnidad());
        unidad.setIdUnidad(unidad2.get().getIdUnidad());
        unidad.setCdUnidad(unidad2.get().getCdUnidad());
        unidad.setNombre(unidad2.get().getNombre());
        unidad.setDescripcion(unidad2.get().getDescripcion());
        unidad.setActivo(unidad2.get().getActivo());
        unidad.setFechaModificacion(unidad2.get().getFechaModificacion());
        unidad.setFechaRegistro(unidad2.get().getFechaRegistro());
        unidad.setUsuario(unidad2.get().getUsuario());
        unidad.setProcesos(unidad2.get().getProcesos());
        unidad.setTipoClasificacion(unidad2.get().getTipoClasificacion());
        unidad.setUnidadAdscripcion(unidad2.get().getUnidadAdscripcion());
        maestroEvaluaciones.setUnidad(unidad);
        this.maestroEvaluacionesRepository.save(maestroEvaluaciones);
        return maestroEvaluaciones;
    }

    @Override
    public DetalleMaestroevaluacionesResponseDto getMaestroById(Integer idMaestroEvaluacion) {
        String boton = "";
        Maestroevaluacion maestroEvaluaciones = this.getMaestro(idMaestroEvaluacion);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(maestroEvaluaciones.getActivo()));
        int activo = Integer.parseInt(deEstatus.get().getValor());
        boton = activo == 1 ? "Desactivar" : "Activar";
        String deActivo = deEstatus.get().getNombre();
        DetalleMaestroevaluacionesResponseDto detalleMaestroevaluacionesResponseDto = new DetalleMaestroevaluacionesResponseDto(maestroEvaluaciones.getIdMaestroEvaluacion(), maestroEvaluaciones.getNombreEvaluacion(), maestroEvaluaciones.getDescripcionEvalua(), maestroEvaluaciones.getFechaApertura(), maestroEvaluaciones.getFechaCorte(), maestroEvaluaciones.getFechaCierre(), activo, deActivo, boton, maestroEvaluaciones.getUnidad().getIdUnidad(), maestroEvaluaciones.getUnidad().getNombre(), maestroEvaluaciones.getUsuario(), maestroEvaluaciones.getFechaRegistro(), maestroEvaluaciones.getFechaModificacion());
        return detalleMaestroevaluacionesResponseDto;
    }

    @Override
    public Maestroevaluacion getMaestro(Integer idMaestroEvaluacion) {
        Maestroevaluacion maestroEvaluaciones = (Maestroevaluacion)this.maestroEvaluacionesRepository.findById(idMaestroEvaluacion).orElseThrow(() -> new IllegalArgumentException("No se encuentra el Maestro de Evaluaci\u00f3n con id: " + idMaestroEvaluacion));
        return maestroEvaluaciones;
    }

    @Override
    public List<DetalleMaestroevaluacionesResponseDto> getMaestros() {
        ArrayList<DetalleMaestroevaluacionesResponseDto> listaDetalleMaestroevaluaciones = new ArrayList<DetalleMaestroevaluacionesResponseDto>();
        List maestroevaluaciones = StreamSupport.stream(this.maestroEvaluacionesRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Maestroevaluacion maestroevaluacion : maestroevaluaciones) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(maestroevaluacion.getActivo()));
            int activo = Integer.parseInt(deEstatus.get().getValor());
            String boton = activo == 1 ? "Desactivar" : "Activar";
            String deActivo = deEstatus.get().getNombre();
            DetalleMaestroevaluacionesResponseDto detalleMaestroevaluaciones = new DetalleMaestroevaluacionesResponseDto(maestroevaluacion.getIdMaestroEvaluacion(), maestroevaluacion.getNombreEvaluacion(), maestroevaluacion.getDescripcionEvalua(), maestroevaluacion.getFechaApertura(), maestroevaluacion.getFechaCorte(), maestroevaluacion.getFechaCierre(), activo, deActivo, boton, maestroevaluacion.getUnidad().getIdUnidad(), maestroevaluacion.getUnidad().getNombre(), maestroevaluacion.getUsuario(), maestroevaluacion.getFechaRegistro(), maestroevaluacion.getFechaModificacion());
            listaDetalleMaestroevaluaciones.add(detalleMaestroevaluaciones);
        }
        return listaDetalleMaestroevaluaciones;
    }

    @Override
    public Maestroevaluacion deleteMaestro(Integer idMaestroEvaluacion, MaestroevaluacionesRequestDto maestroEvaluacionesRequestDto) {
        Maestroevaluacion maestroEvaluacion = (Maestroevaluacion)this.maestroEvaluacionesRepository.getById(idMaestroEvaluacion);
        int valor = maestroEvaluacion.getActivo() == 1 ? 2 : 1;
        maestroEvaluacion.setNombreEvaluacion(maestroEvaluacion.getNombreEvaluacion());
        maestroEvaluacion.setDescripcionEvalua(maestroEvaluacion.getDescripcionEvalua());
        maestroEvaluacion.setFechaApertura(maestroEvaluacion.getFechaApertura());
        maestroEvaluacion.setFechaCorte(maestroEvaluacion.getFechaCorte());
        maestroEvaluacion.setFechaCierre(maestroEvaluacion.getFechaCierre());
        maestroEvaluacion.setActivo(valor);
        maestroEvaluacion.setUsuario(maestroEvaluacion.getUsuario());
        maestroEvaluacion.setFechaModificacion(this.fechaActual);
        maestroEvaluacion.setFechaRegistro(maestroEvaluacion.getFechaRegistro());
        maestroEvaluacion = (Maestroevaluacion)this.maestroEvaluacionesRepository.save(maestroEvaluacion);
        return maestroEvaluacion;
    }

    @Override
    public Maestroevaluacion editMaestro(Integer idMaestroEvaluacion, MaestroevaluacionesRequestDto maestroEvaluacionesRequestDto) {
        Maestroevaluacion maestroEvaluacion = this.getMaestro(idMaestroEvaluacion);
        maestroEvaluacion.setNombreEvaluacion(maestroEvaluacionesRequestDto.getNombreEvaluacion());
        maestroEvaluacion.setDescripcionEvalua(maestroEvaluacionesRequestDto.getDescripcionEvalua());
        maestroEvaluacion.setFechaApertura(maestroEvaluacionesRequestDto.getFechaApertura());
        maestroEvaluacion.setFechaCorte(maestroEvaluacionesRequestDto.getFechaCorte());
        maestroEvaluacion.setFechaCierre(maestroEvaluacionesRequestDto.getFechaCierre());
        maestroEvaluacion.setActivo(maestroEvaluacionesRequestDto.getActivo());
        maestroEvaluacion.setUsuario(maestroEvaluacionesRequestDto.getUsuario());
        maestroEvaluacion.setFechaRegistro(maestroEvaluacionesRequestDto.getFechaRegistro());
        maestroEvaluacion.setFechaModificacion(maestroEvaluacionesRequestDto.getFechaModificacion());
        Optional<Unidad> unidad2 = this.unidadRepository.findById(maestroEvaluacionesRequestDto.getIdUnidad());
        maestroEvaluacion.setUnidad(unidad2.get());
        return (Maestroevaluacion)this.maestroEvaluacionesRepository.save(maestroEvaluacion);
    }

    @Override
    public Optional<Maestroevaluacion> findByNombreEvaluacion(MaestroevaluacionesRequestDto maestroEvaluacionesRequestDto) {
        return this.maestroEvaluacionesRepository.findByNombreEvaluacion(maestroEvaluacionesRequestDto.getNombreEvaluacion());
    }

    @Override
    public boolean existsByNombreEvaluacion(MaestroevaluacionesRequestDto maestroEvaluacionesRequestDto) {
        return this.maestroEvaluacionesRepository.existsByNombreEvaluacion(maestroEvaluacionesRequestDto.getNombreEvaluacion());
    }

    @Override
    public boolean existsByNombreEvaluacion(String nombre) {
        return this.maestroEvaluacionesRepository.existsByNombreEvaluacion(nombre);
    }

    @Override
    public boolean existsById(Integer idMaestroEvaluacion) {
        return this.maestroEvaluacionesRepository.existsById(idMaestroEvaluacion);
    }

    @Override
    public Optional<Maestroevaluacion> getByNombreEvaluacion(String nombre) {
        return this.maestroEvaluacionesRepository.findByNombreEvaluacion(nombre);
    }

    @Override
    public Optional<Maestroevaluacion> getOne(Integer idMaestroEvaluacion) {
        return this.maestroEvaluacionesRepository.findById(idMaestroEvaluacion);
    }

    @Override
    public void save(Maestroevaluacion maestroEvaluaciones) {
        this.maestroEvaluacionesRepository.save(maestroEvaluaciones);
    }

    @Override
    public List<Maestroevaluacion> buscarMaestrosUnidades(Unidad unidad) {
        return this.maestroEvaluacionesRepository.findByUnidad(unidad);
    }
}

