/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.Mapper;
import com.dacrt.SBIABackend.dto.requestDto.DetalleProcesoRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.ProcesoRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleProcesoResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.LineaOperacionResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.ProcesoResponseDto;
import com.dacrt.SBIABackend.entity.Canal;
import com.dacrt.SBIABackend.entity.LineaOperacion;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.Proceso;
import com.dacrt.SBIABackend.repository.CanalRepository;
import com.dacrt.SBIABackend.repository.LineaOperacionRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.ProcesoRepository;
import com.dacrt.SBIABackend.service.ProcesoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ProcesoServiceImpl
implements ProcesoService {
    @Autowired
    private ProcesoRepository procesoRepository;
    @Autowired
    private CanalRepository canalRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    @Autowired
    private LineaOperacionRepository lineaOperacionRepository;

    @Autowired
    public ProcesoServiceImpl(ProcesoRepository procesoRepository) {
        this.procesoRepository = procesoRepository;
    }

    @Override
    public ProcesoResponseDto addProceso(ProcesoRequestDto procesoRequestDto) {
        Proceso proceso = new Proceso();
        proceso.setIdProceso(procesoRequestDto.getIdProceso());
        proceso.setNombre(procesoRequestDto.getNombre());
        proceso.setDescripcion(procesoRequestDto.getDescripcion());
        proceso.setProcesoRemoto(procesoRequestDto.getProcesoRemoto());
        proceso.setTipoProceso(procesoRequestDto.getTipoProceso());
        proceso.setActivo(procesoRequestDto.getActivo());
        proceso.setUsuario(procesoRequestDto.getUsuario());
        proceso.setFechaRegistro(procesoRequestDto.getFechaRegistro());
        proceso.setFechaModificacion(procesoRequestDto.getFechaModificacion());
        LineaOperacion linea = new LineaOperacion();
        Optional<LineaOperacion> linea2 = this.lineaOperacionRepository.findById(procesoRequestDto.getIdLineaoperacion());
        linea.setId_lineaoperacion(linea2.get().getId_lineaoperacion());
        linea.setNombre(linea2.get().getNombre());
        linea.setActivo(linea2.get().getActivo());
        linea.setFechaModificacion(linea2.get().getFechaModificacion());
        linea.setFechaRegistro(linea2.get().getFechaRegistro());
        linea.setUsuario(linea2.get().getUsuario());
        proceso.setLineaOperacion(linea);
        this.procesoRepository.save(proceso);
        return Mapper.procesotoProcesoResponseDto(proceso);
    }

    @Override
    public ProcesoResponseDto addProcesoCanal(ProcesoRequestDto procesoRequestDto) {
        Proceso proceso = new Proceso();
        proceso.setIdProceso(procesoRequestDto.getIdProceso());
        proceso.setNombre(procesoRequestDto.getNombre());
        proceso.setProcesoRemoto(procesoRequestDto.getProcesoRemoto());
        proceso.setActivo(procesoRequestDto.getActivo());
        proceso.setTipoProceso(procesoRequestDto.getTipoProceso());
        proceso.setDescripcion(procesoRequestDto.getDescripcion());
        proceso.setUsuario(procesoRequestDto.getUsuario());
        proceso.setFechaModificacion(procesoRequestDto.getFechaModificacion());
        proceso.setFechaRegistro(procesoRequestDto.getFechaRegistro());
        this.procesoRepository.save(proceso);
        return Mapper.procesotoProcesoResponseDto(proceso);
    }

    @Override
    public List<DetalleProcesoResponseDto> getProcesos() {
        ArrayList<DetalleProcesoResponseDto> listaDetalleProcesos = new ArrayList<DetalleProcesoResponseDto>();
        List procesos = StreamSupport.stream(this.procesoRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Proceso proceso : procesos) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(proceso.getActivo()));
            Optional<Parametros> deTipoProceso = this.parametrosRepository.findByIdtablaAndValor("TIPOPROCESO", String.valueOf(proceso.getTipoProceso()));
            Optional<Parametros> deProcesoRemoto = this.parametrosRepository.findByIdtablaAndValor("PROCESOREMOTO", String.valueOf(proceso.getProcesoRemoto()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            String estatus = deEstatus.get().getNombre();
            int id_tipoproceso = Integer.parseInt(deTipoProceso.get().getValor());
            String tipoproceso = deTipoProceso.get().getNombre();
            int id_procesoremoto = Integer.parseInt(deProcesoRemoto.get().getValor());
            String procesoremoto = deProcesoRemoto.get().getNombre();
            Set<Canal> canales = proceso.getCanales();
            DetalleProcesoResponseDto detalleProceso = new DetalleProcesoResponseDto(proceso.getId_procesamiento(), proceso.getIdProceso(), proceso.getNombre(), proceso.getDescripcion(), id_procesoremoto, procesoremoto, id_tipoproceso, tipoproceso, id_estatus, estatus, boton, proceso.getUsuario(), proceso.getFechaRegistro(), proceso.getFechaModificacion(), proceso.getLineaOperacion().getId_lineaoperacion(), proceso.getLineaOperacion().getNombre(), canales);
            listaDetalleProcesos.add(detalleProceso);
        }
        return listaDetalleProcesos;
    }

    @Override
    public DetalleProcesoResponseDto getProcesoById(Integer id_procesamiento) {
        String boton = "";
        Proceso proceso = this.getProceso(id_procesamiento);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(proceso.getActivo()));
        Optional<Parametros> deTipoProceso = this.parametrosRepository.findByIdtablaAndValor("TIPOPROCESO", String.valueOf(proceso.getTipoProceso()));
        Optional<Parametros> deProcesoRemoto = this.parametrosRepository.findByIdtablaAndValor("PROCESOREMOTO", String.valueOf(proceso.getProcesoRemoto()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        String estatus = deEstatus.get().getNombre();
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        int id_tipoproceso = Integer.parseInt(deTipoProceso.get().getValor());
        String tipoproceso = deTipoProceso.get().getNombre();
        int id_procesoremoto = Integer.parseInt(deProcesoRemoto.get().getValor());
        String procesoremoto = deProcesoRemoto.get().getNombre();
        Optional<LineaOperacion> linea2 = this.lineaOperacionRepository.findById(proceso.getLineaOperacion().getId_lineaoperacion());
        Set<Canal> canales = proceso.getCanales();
        DetalleProcesoResponseDto detalleProcesoResponseDto = new DetalleProcesoResponseDto(proceso.getId_procesamiento(), proceso.getIdProceso(), proceso.getNombre(), proceso.getDescripcion(), id_procesoremoto, procesoremoto, id_tipoproceso, tipoproceso, id_estatus, estatus, boton, proceso.getUsuario(), proceso.getFechaRegistro(), proceso.getFechaModificacion(), proceso.getLineaOperacion().getId_lineaoperacion(), proceso.getLineaOperacion().getNombre(), canales);
        return detalleProcesoResponseDto;
    }

    @Override
    public Proceso getProceso(Integer id_procesamiento) {
        Proceso proceso = (Proceso)this.procesoRepository.findById(id_procesamiento).orElseThrow(() -> new IllegalArgumentException("Proceso con id: " + id_procesamiento + " no puede ser encontrado"));
        return proceso;
    }

    @Override
    public ProcesoResponseDto deleteProceso(Integer id_procesamiento) {
        Proceso proceso = this.getProceso(id_procesamiento);
        proceso.setActivo(1);
        return Mapper.procesotoProcesoResponseDto(proceso);
    }

    @Override
    public Proceso editProceso(Integer id_procesamiento, DetalleProcesoRequestDto procesoRequestDto) {
        Proceso procesoToEdit = this.getProceso(id_procesamiento);
        procesoToEdit.setNombre(procesoRequestDto.getNombre());
        procesoToEdit.setDescripcion(procesoRequestDto.getDescripcion());
        procesoToEdit.setProcesoRemoto(procesoRequestDto.getProcesoRemoto());
        procesoToEdit.setTipoProceso(procesoRequestDto.getTipoProceso());
        procesoToEdit.setActivo(procesoRequestDto.getActivo());
        procesoToEdit.setUsuario(procesoRequestDto.getUsuario());
        procesoToEdit.setFechaRegistro(procesoRequestDto.getFechaRegistro());
        procesoToEdit.setFechaModificacion(procesoRequestDto.getFechaModificacion());
        Optional<LineaOperacion> linea2 = this.lineaOperacionRepository.findById(procesoRequestDto.getIdLineaoperacion());
        procesoToEdit.setLineaOperacion(linea2.get());
        procesoToEdit.setCanales(procesoRequestDto.getCanales());
        return (Proceso)this.procesoRepository.save(procesoToEdit);
    }

    @Override
    public Optional<Proceso> findByNombre(ProcesoRequestDto procesoRequestDto) {
        return this.procesoRepository.findByNombre(procesoRequestDto);
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.procesoRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsByidProceso(String idProceso) {
        return this.procesoRepository.existsByidProceso(idProceso);
    }

    @Override
    public void save(Proceso proceso) {
        this.procesoRepository.save(proceso);
    }

    @Override
    public boolean existsById(Integer id_procesamiento) {
        return this.procesoRepository.existsById(id_procesamiento);
    }

    @Override
    public Optional<Proceso> getByidProceso(String idProceso) {
        return this.procesoRepository.findByidProceso(idProceso);
    }

    @Override
    public Optional<Proceso> getByNombre(String nombre) {
        return this.procesoRepository.findByNombre(nombre);
    }

    public Optional<Proceso> getOne(int id_procesamiento) {
        return this.procesoRepository.findById(id_procesamiento);
    }

    @Override
    public LineaOperacionResponseDto getLineaOperacionProcesoById(Integer id_procesamiento) {
        Proceso proceso = this.getProceso(id_procesamiento);
        LineaOperacionResponseDto lineaOperacionResponseDto = new LineaOperacionResponseDto();
        Optional<LineaOperacion> linea2 = this.lineaOperacionRepository.findById(proceso.getLineaOperacion().getId_lineaoperacion());
        lineaOperacionResponseDto.setId_lineaoperacion(linea2.get().getId_lineaoperacion());
        lineaOperacionResponseDto.setNombre(linea2.get().getNombre());
        lineaOperacionResponseDto.setActivo(linea2.get().getActivo());
        lineaOperacionResponseDto.setFechaModificacion(linea2.get().getFechaModificacion());
        lineaOperacionResponseDto.setFechaRegistro(linea2.get().getFechaRegistro());
        lineaOperacionResponseDto.setUsuario(linea2.get().getUsuario());
        return lineaOperacionResponseDto;
    }

    @Override
    public Optional<Proceso> getOne(Integer id_procesamiento) {
        return Optional.empty();
    }

    @Override
    public long countProceso() {
        return this.procesoRepository.count();
    }
}

