/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.responseDto.DetalleTipoInsumoResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.TipoInsumo;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.TipoInsumoRepository;
import com.dacrt.SBIABackend.service.TipoInsumoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class TipoInsumoServiceImpl
implements TipoInsumoService {
    @Autowired
    private TipoInsumoRepository tipoInsumoRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    Date fechaActual = new Date();

    @Autowired
    public TipoInsumoServiceImpl(TipoInsumoRepository tipoInsumoRepository) {
        this.tipoInsumoRepository = tipoInsumoRepository;
    }

    @Override
    public List<DetalleTipoInsumoResponseDto> getTipoInsumos() {
        ArrayList<DetalleTipoInsumoResponseDto> listaDetalleTipoInsumo = new ArrayList<DetalleTipoInsumoResponseDto>();
        List insumos = StreamSupport.stream(this.tipoInsumoRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (TipoInsumo tipoInsumo : insumos) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(tipoInsumo.getActivo()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            String estatus = deEstatus.get().getNombre();
            DetalleTipoInsumoResponseDto detalleTipoInsumo = new DetalleTipoInsumoResponseDto(tipoInsumo.getId_tipoinsumo(), tipoInsumo.getNombre(), tipoInsumo.getActivo(), estatus, boton, tipoInsumo.getUsuario(), tipoInsumo.getFechaRegistro(), tipoInsumo.getFechaModificacion());
            listaDetalleTipoInsumo.add(detalleTipoInsumo);
        }
        return listaDetalleTipoInsumo;
    }

    @Override
    public DetalleTipoInsumoResponseDto getTipoInsumoById(Integer id_tipoinsumo) {
        String boton = "";
        TipoInsumo tipoInsumo = this.getTipoInsumo(id_tipoinsumo);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(tipoInsumo.getActivo()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        DetalleTipoInsumoResponseDto detalleTipoInsumoResponseDto = new DetalleTipoInsumoResponseDto(tipoInsumo.getId_tipoinsumo(), tipoInsumo.getNombre(), id_estatus, estatus, boton, tipoInsumo.getUsuario(), tipoInsumo.getFechaRegistro(), tipoInsumo.getFechaModificacion());
        return detalleTipoInsumoResponseDto;
    }

    @Override
    public TipoInsumo getTipoInsumo(Integer id_tipoinsumo) {
        TipoInsumo tipoInsumo = (TipoInsumo)this.tipoInsumoRepository.findById(id_tipoinsumo).orElseThrow(() -> new IllegalArgumentException("No se encuentra el tipo de insumo con id: " + id_tipoinsumo));
        return tipoInsumo;
    }

    @Override
    public Optional<TipoInsumo> getByNombre(String nombre) {
        return this.tipoInsumoRepository.findByNombre(nombre);
    }

    @Override
    public TipoInsumo addTipoInsumo(TipoInsumo tipoInsumo) {
        return (TipoInsumo)this.tipoInsumoRepository.save(tipoInsumo);
    }

    @Override
    public TipoInsumo deleteTipoInsumo(Integer id_tipoinsumo, TipoInsumo tipoInsumo) {
        return (TipoInsumo)this.tipoInsumoRepository.save(tipoInsumo);
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.tipoInsumoRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsById(Integer id_tipoinsumo) {
        return this.tipoInsumoRepository.existsById(id_tipoinsumo);
    }
}

