/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.Mapper;
import com.dacrt.SBIABackend.dto.requestDto.UnidadRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleUnidadResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.UnidadResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.Proceso;
import com.dacrt.SBIABackend.entity.Unidad;
import com.dacrt.SBIABackend.entity.UnidadAdscripcion;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.UnidadAdscripcionRepository;
import com.dacrt.SBIABackend.repository.UnidadRepository;
import com.dacrt.SBIABackend.service.UnidadService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class UnidadServiceImpl
implements UnidadService {
    @Autowired
    private UnidadRepository unidadRepository;
    @Autowired
    private UnidadAdscripcionRepository unidadAdscripcionRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;

    @Override
    public List<DetalleUnidadResponseDto> getUnidades() {
        ArrayList<DetalleUnidadResponseDto> listaUnidades = new ArrayList<DetalleUnidadResponseDto>();
        List unidades = StreamSupport.stream(this.unidadRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Unidad unidad : unidades) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(unidad.getActivo()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String estatus = deEstatus.get().getNombre();
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            Optional<Parametros> deClasificacion = this.parametrosRepository.findByIdtablaAndValor("TIPOCLASIFICACION", String.valueOf(unidad.getTipoClasificacion()));
            int id_tipoClasificacion = Integer.parseInt(deClasificacion.get().getValor());
            String tipoClasificacion = deClasificacion.get().getNombre();
            Set<Proceso> procesos = unidad.getProcesos();
            DetalleUnidadResponseDto detalleUnidad = new DetalleUnidadResponseDto(unidad.getIdUnidad(), unidad.getCdUnidad(), unidad.getNombre(), unidad.getDescripcion(), id_estatus, estatus, boton, id_tipoClasificacion, tipoClasificacion, unidad.getUsuario(), unidad.getFechaRegistro(), unidad.getFechaModificacion(), unidad.getUnidadAdscripcion() != null ? Integer.valueOf(unidad.getUnidadAdscripcion().getIdUnidadAdscripcion()) : null, unidad.getUnidadAdscripcion() != null ? unidad.getUnidadAdscripcion().getNombre() : null, procesos);
            listaUnidades.add(detalleUnidad);
        }
        return listaUnidades;
    }

    @Override
    public DetalleUnidadResponseDto getUnidadById(Integer idUnidad) {
        Unidad unidad = this.getUnidad(idUnidad);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(unidad.getActivo()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        String boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        Optional<Parametros> deClasificacion = this.parametrosRepository.findByIdtablaAndValor("TIPOCLASIFICACION", String.valueOf(unidad.getTipoClasificacion()));
        int id_tipoClasificacion = Integer.parseInt(deClasificacion.get().getValor());
        String tipoClasificacion = deClasificacion.get().getNombre();
        Set<Proceso> procesos = unidad.getProcesos();
        DetalleUnidadResponseDto detalleUnidadResponseDto = new DetalleUnidadResponseDto(unidad.getIdUnidad(), unidad.getCdUnidad(), unidad.getNombre(), unidad.getDescripcion(), id_estatus, estatus, boton, id_tipoClasificacion, tipoClasificacion, unidad.getUsuario(), unidad.getFechaRegistro(), unidad.getFechaModificacion(), unidad.getUnidadAdscripcion() != null ? Integer.valueOf(unidad.getUnidadAdscripcion().getIdUnidadAdscripcion()) : null, unidad.getUnidadAdscripcion() != null ? unidad.getUnidadAdscripcion().getNombre() : "", procesos);
        return detalleUnidadResponseDto;
    }

    @Override
    public Unidad getUnidad(Integer idUnidad) {
        Unidad unidad = this.unidadRepository.findById(idUnidad).orElseThrow(() -> new IllegalArgumentException("No se encuentra la unidad con id: " + idUnidad));
        return unidad;
    }

    @Override
    public Optional<Unidad> getByNombre(String nombre) {
        return this.unidadRepository.findByNombre(nombre);
    }

    @Override
    public Optional<Unidad> getByCdUnidad(String cdUnidad) {
        return this.unidadRepository.findByCdUnidad(cdUnidad);
    }

    @Override
    @Transactional
    public UnidadResponseDto addUnidad(UnidadRequestDto unidadRequestDto) {
        Unidad unidad = this.convertirDTOAEntidad(unidadRequestDto);
        return Mapper.unidadtoUnidadResponseDto((Unidad)this.unidadRepository.save(unidad));
    }

    @Override
    @Transactional
    public UnidadResponseDto editUnidad(UnidadRequestDto unidadRequestDto) {
        Unidad unidad = this.convertirDTOAEntidad(unidadRequestDto);
        return Mapper.unidadtoUnidadResponseDto((Unidad)this.unidadRepository.save(unidad));
    }

    @Override
    public Unidad convertirDTOAEntidad(UnidadRequestDto unidadRequestDto) {
        Unidad unidad = new Unidad();
        unidad.setCdUnidad(unidadRequestDto.getCdUnidad());
        unidad.setNombre(unidadRequestDto.getNombre());
        unidad.setDescripcion(unidadRequestDto.getDescripcion());
        unidad.setActivo(unidadRequestDto.getActivo());
        unidad.setTipoClasificacion(unidadRequestDto.getTipoClasificacion());
        unidad.setFechaRegistro(unidadRequestDto.getFechaRegistro());
        unidad.setFechaModificacion(unidadRequestDto.getFechaModificacion());
        unidad.setUsuario(unidadRequestDto.getUsuario());
        unidad.setProcesos(unidadRequestDto.getProcesos());
        if (unidadRequestDto.getIdUnidadAdscripcion() != 0) {
            UnidadAdscripcion unidadAdscripcion = this.unidadAdscripcionRepository.findById(unidadRequestDto.getIdUnidadAdscripcion()).orElseThrow(() -> new RuntimeException("Unidad Adscripta no encontrada"));
            unidad.setUnidadAdscripcion(unidadAdscripcion);
        }
        return unidad;
    }

    @Override
    public boolean existsByNombre(UnidadRequestDto unidadRequestDto) {
        return this.unidadRepository.existsByNombre(unidadRequestDto.getNombre());
    }

    @Override
    public boolean existsByCdUnidad(String cdUnidad) {
        return this.unidadRepository.existsByCdUnidad(cdUnidad);
    }

    @Override
    public boolean existsById(Integer idUnidad) {
        return this.unidadRepository.existsById(idUnidad);
    }

    @Override
    public Optional<Unidad> findById(Integer idUnidad) {
        return this.unidadRepository.findById(idUnidad);
    }

    @Override
    public Optional<Unidad> getOne(Integer idUnidad) {
        return this.unidadRepository.findById(idUnidad);
    }

    @Override
    public void save(Unidad unidad) {
        this.unidadRepository.save(unidad);
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.unidadRepository.existsByNombre(nombre);
    }

    @Override
    public long countProcesosPorUnidad(Integer idUnidad) {
        return 0L;
    }
}

