/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.security.dto.AuditRequestDto;
import com.dacrt.SBIABackend.security.dto.MenuResponseDto;
import com.dacrt.SBIABackend.security.dto.RespuestaDto;
import com.dacrt.SBIABackend.security.dto.RespuestaMsgDto;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import com.dacrt.SBIABackend.security.service.MenuService;
import com.dacrt.SBIABackend.security.service.SecurityService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/home"})
@CrossOrigin(origins={"*"})
public class MenuControler {
    @Autowired
    MenuService menuService;
    @Autowired
    private ParamsRepository paramsRepository;
    @Autowired
    private UsersRepository usersRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityService securityService;
    Logger logger = LoggerFactory.getLogger(MenuControler.class);

    @GetMapping(value={"/menus"})
    public ResponseEntity<MenuResponseDto> menu(HttpServletRequest request) throws ParseException {
        Optional encontreSessionUsuario;
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        try {
            if (sessionid == null) {
                String var = "";
                boolean bloked = false;
                RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
                respuestaDto.setBlocked(bloked);
                respuestaDto.setMsg("Llamada al servicio malformado");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
            }
            encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
            if (encontreSessionUsuario.isPresent()) {
                Date fecha2 = new Date();
                Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
                String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
                if (fechaComoCadena == "") {
                    String var2 = "";
                    boolean bloked2 = false;
                    RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                    respuestaDto2.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                    return new ResponseEntity((Object)respuestaDto2, HttpStatus.UNAUTHORIZED);
                }
            }
            if (this.menuService.getMenu(sessionid) == null) {
                String var = "";
                boolean bloked = false;
                RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
                respuestaDto.setBlocked(bloked);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            String var = e.getMessage();
            boolean bloked = false;
            RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
            respuestaDto.setBlocked(bloked);
            respuestaDto.setMsg("Error interno del servidor");
            respuestaDto.setMsg(var);
            return new ResponseEntity((Object)respuestaDto, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid);
        return ResponseEntity.ok((Object)this.menuService.getMenu(sessionid));
    }
}

