/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.security.dto.ParametrosSeguridadDto;
import com.dacrt.SBIABackend.security.service.ParametrosSeguridadService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/parametrosseguridad"})
@CrossOrigin(origins={"*"})
public class ParametrosSeguridadController {
    @Autowired
    ParametrosSeguridadService parametrosSeguridadService;
    Logger logger = LoggerFactory.getLogger(ParametrosSeguridadController.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/detail"})
    public ResponseEntity<ParametrosSeguridadDto> getParametrosSeguridad() {
        ParametrosSeguridadDto parametrosSeguridadDto = this.parametrosSeguridadService.getParametrosSeguridad();
        return new ResponseEntity((Object)parametrosSeguridadDto, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update"})
    public ResponseEntity<ParametrosSeguridadDto> editParametrosSeguridad(@RequestBody ParametrosSeguridadDto parametrosSeguridadDto) {
        try {
            this.parametrosSeguridadService.editParametrosSeguridad(parametrosSeguridadDto);
            ParametrosSeguridadDto detalleUsuario = this.parametrosSeguridadService.getParametrosSeguridad();
            return new ResponseEntity((Object)detalleUsuario, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

