/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.security.dto.AuditRequestDto;
import com.dacrt.SBIABackend.security.dto.PrivileResponseDto;
import com.dacrt.SBIABackend.security.dto.PrivilegeUniqueResponseDto;
import com.dacrt.SBIABackend.security.dto.PrivilegesListDto;
import com.dacrt.SBIABackend.security.dto.PrivilegesResponseDto;
import com.dacrt.SBIABackend.security.dto.RespuestaMsgDto;
import com.dacrt.SBIABackend.security.dto.RolAssinedRequestDto;
import com.dacrt.SBIABackend.security.dto.RolPrivilegioAssignedResponseDto;
import com.dacrt.SBIABackend.security.dto.RolesAssignedResponseDto;
import com.dacrt.SBIABackend.security.dto.RolesResponseDto;
import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.entity.Roles;
import com.dacrt.SBIABackend.security.entity.Rolesprivileges;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.AuditRepository;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.PrivilegesRepository;
import com.dacrt.SBIABackend.security.repository.RolesPrivilegesRepository;
import com.dacrt.SBIABackend.security.repository.RolesRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import com.dacrt.SBIABackend.security.service.MenuService;
import com.dacrt.SBIABackend.security.service.SecurityService;
import com.dacrt.SBIABackend.security.service.UsersService;
import com.dacrt.SBIABackend.utils.HttpReqRespUtils;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class PrivilegesController {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PrivilegesRepository privilegesRepository;
    @Autowired
    private RolesPrivilegesRepository rolesPrivilegesRepository;
    @Autowired
    private ParamsRepository paramsRepository;
    @Autowired
    private RolesRepository rolesRepository;
    @Autowired
    private AuditRepository auditRepository;
    @Autowired
    private UsersRepository usersRepository;
    @Autowired
    MenuService menuService;
    @Autowired
    SecurityService securityService;
    @Autowired
    UsersService usersService;
    Logger logger = LoggerFactory.getLogger(PrivilegesController.class);

    @PostMapping(value={"/privileges"})
    public ResponseEntity<?> listarPrivilegios(HttpServletRequest request, @RequestBody PrivilegesListDto tiposfiltros) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        long cuantosregistro = 0L;
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        String searchIn = "";
        String searchModule = "";
        String searchUsr = "";
        String contentIn = "";
        int orderIn = 0;
        int offsetIn = 0;
        int numofrecordsIn = 0;
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        SimpleDateFormat salida = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String fechaComoCadena = salida.format(ValidThrufechaSalida);
        System.out.println(fechaComoCadena);
        if (sessionid == null) {
            respuesta.setMsg("Llamada al servicio malformado");
            estatus = HttpStatus.BAD_REQUEST;
            return new ResponseEntity((Object)respuesta, estatus);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var2 = "";
                boolean bloked2 = false;
                RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                respuestaDto2.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto2, HttpStatus.UNAUTHORIZED);
            }
            int rolisvalid = 0;
            rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 620);
            if (rolisvalid == 0) {
                respuesta.setMsg("No tiene los Privilegios");
                estatus = HttpStatus.FORBIDDEN;
                return new ResponseEntity((Object)respuesta, estatus);
            }
            searchIn = tiposfiltros.getFilters().getSearch();
            searchModule = tiposfiltros.getFilters().getModule();
            searchUsr = tiposfiltros.getFilters().getUser();
            orderIn = tiposfiltros.getOrder();
            offsetIn = tiposfiltros.getOffset();
            numofrecordsIn = tiposfiltros.getNumofrecords();
            contentIn = tiposfiltros.getContent();
            if (contentIn != null && contentIn != "") {
                this.menuService.iscontentdiffnull(contentIn, ((Users)encontreSessionUsuario.get()).getId());
            }
        } else {
            respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            estatus = HttpStatus.BAD_REQUEST;
            return new ResponseEntity((Object)respuesta, estatus);
        }
        ArrayList privilegiosMov = new ArrayList();
        ArrayList rolesPrivilegiosMov = new ArrayList();
        PrivilegesResponseDto privilegesResponseDto = new PrivilegesResponseDto();
        PrivileResponseDto privilegios = new PrivileResponseDto();
        ArrayList<PrivileResponseDto> records = new ArrayList<PrivileResponseDto>();
        RolesAssignedResponseDto rolesAsignned = new RolesAssignedResponseDto();
        ArrayList<RolesAssignedResponseDto> ro = new ArrayList<RolesAssignedResponseDto>();
        try {
            String SentenciaBase = "SELECT new com.dacrt.SBIABackend.security.dto.PrivilegeUniqueResponseDto(p.id,p.grp,p.name,p.crud,p.ord) FROM Privileges p";
            String SentenciaPrivilegios = "SELECT new com.dacrt.SBIABackend.security.dto.RolesAssignedResponseDto(r.id, r.name, CASE WHEN EXISTS (SELECT 1 FROM Rolesprivileges rp WHERE rp.rolid = r.id AND rp.privilegeid = :privilegioId) THEN TRUE ELSE FALSE END) FROM Roles r";
            String QueryTotal = "";
            String name = "p.name";
            String grp = "p.grp";
            String ord = "p.ord";
            String lowername = "LOWER(p.name)";
            String lowergrp = "LOWER(p.grp)";
            String LowerSearch = searchIn.toLowerCase();
            switch (searchIn) {
                case "": {
                    QueryTotal = SentenciaBase;
                    break;
                }
                default: {
                    QueryTotal = String.valueOf(SentenciaBase) + " WHERE " + lowergrp + " LIKE  " + "'%" + LowerSearch + "%'" + " OR " + lowername + " LIKE " + "'%" + LowerSearch + "%'";
                }
            }
            switch (orderIn) {
                case 1: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + grp + " ASC" + "," + ord + " ASC" + "," + name + " ASC";
                    break;
                }
                case 2: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + grp + " ASC";
                    break;
                }
                case 3: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + ord + " ASC";
                    break;
                }
                case 4: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + name + " ASC";
                    break;
                }
                case -1: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + grp + " DESC" + "," + ord + " DESC" + "," + name + " DESC";
                    break;
                }
                case -2: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + grp + " DESC";
                    break;
                }
                case -3: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + ord + " DESC";
                    break;
                }
                case -4: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + name + " DESC";
                    break;
                }
                default: {
                    respuesta.setMsg("Error interno del servidor");
                    estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
                    return responseEntity;
                }
            }
            TypedQuery privile = this.entityManager.createQuery(QueryTotal, PrivilegeUniqueResponseDto.class);
            cuantosregistro = privile.getResultList().size();
            privile.setFirstResult(offsetIn);
            privile.setMaxResults(numofrecordsIn);
            List privilegs = privile.getResultList();
            for (PrivilegeUniqueResponseDto priv : privilegs) {
                privilegios.setId(priv.getId());
                privilegios.setGroup(priv.getGrp());
                privilegios.setCrud(priv.getCrud());
                privilegios.setName(priv.getName());
                TypedQuery query = this.entityManager.createQuery(SentenciaPrivilegios, RolesAssignedResponseDto.class);
                query.setParameter("privilegioId", (Object)priv.getId());
                List resultados = query.getResultList();
                for (RolesAssignedResponseDto resultado : resultados) {
                    rolesAsignned.setId(resultado.getId());
                    rolesAsignned.setName(resultado.getName());
                    rolesAsignned.setAssigned(resultado.isAssigned());
                    ro.add(rolesAsignned);
                    rolesAsignned = new RolesAssignedResponseDto();
                }
                privilegios.setRoles(ro);
                ro = new ArrayList();
                records.add(privilegios);
                privilegios = new PrivileResponseDto();
            }
            privilegesResponseDto.setNumofrecords(Long.valueOf(cuantosregistro));
            privilegesResponseDto.setRecords(records);
            privilegesResponseDto.setSessionvalidthru(fechaComoCadena);
            ResponseEntity responseEntity = new ResponseEntity((Object)privilegesResponseDto, HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            respuesta.setMsg("Error interno del servidor ");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        return new ResponseEntity((Object)respuesta, HttpStatus.OK);
    }

    @PostMapping(value={"/privileges/{privilegeid}"})
    public ResponseEntity<?> asignaDesasignaPrivilegios(HttpServletRequest request, @RequestBody RolAssinedRequestDto rolasigdes, @PathVariable(value="privilegeid") Integer privilegeid) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        RolesResponseDto rolesResponseDto = new RolesResponseDto();
        long cuantosregistro = 0L;
        ArrayList listasRoles = new ArrayList();
        ArrayList listasPrivelege = new ArrayList();
        String privilegeidChar = privilegeid.toString();
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        String searchIn = "";
        boolean orderIn = false;
        boolean offsetIn = false;
        boolean numofrecordsIn = false;
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        SimpleDateFormat salida = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String fechaComoCadena = salida.format(ValidThrufechaSalida);
        System.out.println(fechaComoCadena);
        RolPrivilegioAssignedResponseDto rolPrivilegioAssignedResponseDto = new RolPrivilegioAssignedResponseDto();
        int cuentaExiste = 0;
        String module = "";
        String Descmodule = "";
        Rolesprivileges rolesPrivileges = new Rolesprivileges();
        try {
            if (sessionid == null) {
                respuesta.setMsg("Llamada al servicio malformado");
                estatus = HttpStatus.BAD_REQUEST;
                return new ResponseEntity((Object)respuesta, estatus);
            }
            Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
            if (encontreSessionUsuario.isPresent()) {
                Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
                fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
                if (fechaComoCadena == "") {
                    String var2 = "";
                    boolean bloked2 = false;
                    RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                    respuestaDto2.setMsg("Sesi\u00f3n expirada o invalida");
                    return new ResponseEntity((Object)respuestaDto2, HttpStatus.UNAUTHORIZED);
                }
                int rolisvalid = 0;
                rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 621);
                if (rolisvalid == 0) {
                    respuesta.setMsg("No tiene los Privilegios");
                    return new ResponseEntity((Object)respuesta, HttpStatus.FORBIDDEN);
                }
                boolean existeRol = this.rolesRepository.existsById(rolasigdes.getRoleid());
                if (!existeRol) {
                    respuesta.setMsg("Registro no encontrado");
                    return new ResponseEntity((Object)respuesta, HttpStatus.NOT_FOUND);
                }
                cuentaExiste = this.rolesPrivilegesRepository.existeRolPrivilegio(rolasigdes.getRoleid(), privilegeid.intValue());
                if (cuentaExiste == 0) {
                    rolesPrivileges.setPrivilegeid(privilegeid.intValue());
                    rolesPrivileges.setRolid(rolasigdes.getRoleid());
                    rolesPrivileges.setCreatedat(fecha2);
                    rolesPrivileges.setModifiedat(fecha2);
                    this.rolesPrivilegesRepository.save((Object)rolesPrivileges);
                    rolPrivilegioAssignedResponseDto.setSessionvalidthru(fechaComoCadena);
                    rolPrivilegioAssignedResponseDto.setRoleid(Integer.valueOf(rolasigdes.getRoleid()));
                    rolPrivilegioAssignedResponseDto.setPrivilegeid(privilegeid);
                    rolPrivilegioAssignedResponseDto.setAssigned(true);
                    Optional roleamodificar = this.rolesRepository.findById(rolasigdes.getRoleid());
                    module = "Privilegios";
                    Descmodule = "Se asignaron los privilegios del rol: " + ((Roles)roleamodificar.get()).getName() + " con el id del Privilegio: " + privilegeid;
                    auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                    String singo1 = "(";
                    String singo2 = ")";
                    String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                    auditDto.setUserref(usryemail);
                    auditDto.setModule(module);
                    auditDto.setDesc(Descmodule);
                    auditDto.setCreatedat(fechaDate);
                    this.usersService.registrarAuditSesion(auditDto);
                    URI location = URI.create("/privileges/".concat(privilegeidChar));
                    return ResponseEntity.created((URI)location).body((Object)rolPrivilegioAssignedResponseDto);
                }
                this.rolesPrivilegesRepository.borrarRolPrivilegio(rolasigdes.getRoleid(), privilegeid.intValue());
                rolPrivilegioAssignedResponseDto.setSessionvalidthru(fechaComoCadena);
                rolPrivilegioAssignedResponseDto.setRoleid(Integer.valueOf(rolasigdes.getRoleid()));
                rolPrivilegioAssignedResponseDto.setPrivilegeid(privilegeid);
                rolPrivilegioAssignedResponseDto.setAssigned(false);
                Optional roleamodificar = this.rolesRepository.findById(rolasigdes.getRoleid());
                module = "Privilegios";
                Descmodule = "Se eliminaron los privilegios del rol: " + ((Roles)roleamodificar.get()).getName() + " con el id del Privilegio: " + privilegeid;
                auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                String singo1 = "(";
                String singo2 = ")";
                String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                auditDto.setUserref(usryemail);
                auditDto.setModule(module);
                auditDto.setDesc(Descmodule);
                auditDto.setCreatedat(fechaDate);
                this.usersService.registrarAuditSesion(auditDto);
                URI location = URI.create("/privileges/".concat(privilegeidChar));
                return ResponseEntity.created((URI)location).body((Object)rolPrivilegioAssignedResponseDto);
            }
        }
        catch (Exception e) {
            respuesta.setMsg("Error interno del servidor");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return new ResponseEntity((Object)respuesta, HttpStatus.OK);
    }
}

