/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.security.dto.AccesoDto;
import com.dacrt.SBIABackend.security.dto.RolAccesoDto;
import com.dacrt.SBIABackend.security.dto.RolRequestDto;
import com.dacrt.SBIABackend.security.entity.OpcionDeBIA;
import com.dacrt.SBIABackend.security.entity.Rol;
import com.dacrt.SBIABackend.security.entity.RolOpcionDeBIA;
import com.dacrt.SBIABackend.security.service.OpcionDeBIAService;
import com.dacrt.SBIABackend.security.service.RolOpcionDeBIAService;
import com.dacrt.SBIABackend.security.service.RolService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roles"})
@CrossOrigin(origins={"*"})
public class RolController {
    @Autowired
    RolService rolService;
    @Autowired
    OpcionDeBIAService opcionDeBIAService;
    @Autowired
    RolOpcionDeBIAService rolOpcionDeBIAService;
    Logger logger = LoggerFactory.getLogger(RolController.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> addRol(@RequestBody RolRequestDto rolRequestDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResponseEntity((Object)new Mensaje("Campos mal puestos"), HttpStatus.BAD_REQUEST);
        }
        if (this.rolService.existsByRolNombre(rolRequestDto.getRolNombre())) {
            return new ResponseEntity((Object)new Mensaje("Ese nombre ya existe"), HttpStatus.BAD_REQUEST);
        }
        try {
            Rol rol = new Rol();
            rol.setRolNombre(rolRequestDto.getRolNombre());
            rol.setActivo(rolRequestDto.getActivo());
            rol.setRegistradoPor(rolRequestDto.getRegistradoPor());
            rol.setFechaRegistro(rolRequestDto.getFechaRegistro());
            rol.setModificadoPor(rolRequestDto.getModificadoPor());
            rol.setFechaModificacion(rolRequestDto.getFechaModificacion());
            this.rolService.save(rol);
            Optional optionalRol = this.rolService.getByRolNombre(rolRequestDto.getRolNombre());
            if (optionalRol.isPresent()) {
                for (String opcionDeBIA : rolRequestDto.getOpcionesDeBIA()) {
                    String opcion = opcionDeBIA.split("|")[0];
                    String modo = opcionDeBIA.split("|")[1];
                    Optional optionalOpcionDeBIA = this.opcionDeBIAService.findByOpcion(opcion);
                    if (!optionalOpcionDeBIA.isPresent()) continue;
                    RolOpcionDeBIA rolOpcionDeBIA = new RolOpcionDeBIA();
                    rolOpcionDeBIA.setRol((Rol)optionalRol.get());
                    rolOpcionDeBIA.setOpcionDeBIA((OpcionDeBIA)optionalOpcionDeBIA.get());
                    rolOpcionDeBIA.setModo(modo);
                    this.rolOpcionDeBIAService.save(rolOpcionDeBIA);
                }
            } else {
                return new ResponseEntity((Object)new Mensaje("Hubo un problema en la creaci\u00f3n de rol."), HttpStatus.OK);
            }
            return new ResponseEntity((Object)new Mensaje("El proceso fue creado exitosamente"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PostMapping(value={"/conectarol"})
    public ResponseEntity<AccesoDto> conectarol(@Valid @RequestBody RolAccesoDto rolAccesoDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResponseEntity((Object)new Mensaje("Campos mal puestos"), HttpStatus.BAD_REQUEST);
        }
        ArrayList<String> accesos = new ArrayList<String>();
        Set rolesOpcionesDeBIA = this.rolService.buscarOpcionesDeRol(rolAccesoDto.getRolNombre());
        for (RolOpcionDeBIA rolOpcionDeBIA : rolesOpcionesDeBIA) {
            accesos.add(String.valueOf(rolOpcionDeBIA.getOpcionDeBIA().getOpcion()) + "|" + rolOpcionDeBIA.getModo());
        }
        AccesoDto accesoDto = new AccesoDto();
        accesoDto.setAccesos(accesos);
        return new ResponseEntity((Object)accesoDto, HttpStatus.OK);
    }

    @GetMapping(value={"/listaroles"})
    public ResponseEntity<List<RolAccesoDto>> getUnidades() {
        List rolAccesoDtos = this.rolService.getRoles();
        return new ResponseEntity((Object)rolAccesoDtos, HttpStatus.OK);
    }
}

