/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.security.dto.AuditRequestDto;
import com.dacrt.SBIABackend.security.dto.EntryDto;
import com.dacrt.SBIABackend.security.dto.PrivilegesAllDto;
import com.dacrt.SBIABackend.security.dto.RespuestaDto;
import com.dacrt.SBIABackend.security.dto.RespuestaMsgDto;
import com.dacrt.SBIABackend.security.dto.RespuestaValueDto;
import com.dacrt.SBIABackend.security.dto.RolNameDto;
import com.dacrt.SBIABackend.security.dto.RoleDto;
import com.dacrt.SBIABackend.security.dto.RolesDto;
import com.dacrt.SBIABackend.security.dto.RolesResponseDto;
import com.dacrt.SBIABackend.security.dto.RolesUserDto;
import com.dacrt.SBIABackend.security.dto.UsersListDto;
import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.entity.Roles;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.AuditRepository;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.PrivilegesRepository;
import com.dacrt.SBIABackend.security.repository.RolesPrivilegesRepository;
import com.dacrt.SBIABackend.security.repository.RolesRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import com.dacrt.SBIABackend.security.service.MenuService;
import com.dacrt.SBIABackend.security.service.SecurityService;
import com.dacrt.SBIABackend.security.service.UsersService;
import com.dacrt.SBIABackend.utils.HttpReqRespUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class RolesController<JSONObject> {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UsersRepository usersRepository;
    @Autowired
    private ParamsRepository paramsRepository;
    @Autowired
    private RolesRepository rolesRepository;
    @Autowired
    private PrivilegesRepository privilegesRepository;
    @Autowired
    private RolesPrivilegesRepository rolesPrivilegesRepository;
    @Autowired
    UsersService usersService;
    @Autowired
    MenuService menuService;
    @Autowired
    SecurityService securityService;
    @Autowired
    private AuditRepository auditRepository;
    @Autowired
    private ObjectMapper objectMapper;
    Logger logger = LoggerFactory.getLogger(RolesController.class);

    @PostMapping(value={"/roles"})
    public ResponseEntity<?> listarRoles(HttpServletRequest request, @RequestBody UsersListDto tiposfiltros) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        RolesResponseDto rolesResponseDto = new RolesResponseDto();
        Long cuantosregistro = 0L;
        ArrayList listasRoles = new ArrayList();
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        String searchIn = "";
        String searchModule = "";
        String searchUsr = "";
        String contentIn = "";
        int orderIn = 0;
        int offsetIn = 0;
        int numofrecordsIn = 0;
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        Optional deEntryPoint = this.paramsRepository.findByParamname("ENTRY_POINT");
        String entrypoint = ((Params)deEntryPoint.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        if (sessionid == null) {
            respuesta.setMsg("Llamada al servicio malformado");
            return new ResponseEntity((Object)respuesta, HttpStatus.BAD_REQUEST);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var2 = "";
                boolean bloked2 = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var2);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            int rolisvalid = 0;
            rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 620);
            if (rolisvalid == 0) {
                respuesta.setMsg("No tiene los Privilegios");
                return new ResponseEntity((Object)respuesta, HttpStatus.FORBIDDEN);
            }
            searchIn = tiposfiltros.getFilters().getSearch();
            searchModule = tiposfiltros.getFilters().getModule();
            searchUsr = tiposfiltros.getFilters().getUser();
            orderIn = tiposfiltros.getOrder();
            offsetIn = tiposfiltros.getOffset();
            numofrecordsIn = tiposfiltros.getNumofrecords();
            contentIn = tiposfiltros.getContent();
            if (contentIn != null && contentIn != "") {
                this.menuService.iscontentdiffnull(contentIn, ((Users)encontreSessionUsuario.get()).getId());
            }
        } else {
            respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            return new ResponseEntity((Object)respuesta, HttpStatus.BAD_REQUEST);
        }
        try {
            String SentenciaBase = "SELECT new com.dacrt.SBIABackend.security.dto.RolesDto (r.id, r.name,r.createdat) FROM Roles r";
            String QueryTotal = "";
            String name = "r.name";
            String createdat = "r.createdat";
            String lowername = "LOWER(r.name)";
            String LowerSearch = searchIn.toLowerCase();
            switch (searchIn) {
                case "": {
                    QueryTotal = SentenciaBase;
                    break;
                }
                default: {
                    QueryTotal = String.valueOf(SentenciaBase) + " WHERE " + lowername + " LIKE  " + "'%" + LowerSearch + "%'";
                }
            }
            switch (orderIn) {
                case 1: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + createdat + " ASC" + "," + name + " ASC";
                    break;
                }
                case 2: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + createdat + " ASC";
                    break;
                }
                case 3: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + name + " ASC";
                    break;
                }
                case -1: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + createdat + " DESC" + "," + name + " DESC";
                    break;
                }
                case -2: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + createdat + " DESC";
                    break;
                }
                case -3: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + name + " DESC";
                    break;
                }
                default: {
                    respuesta.setMsg("Error interno del servidor");
                    estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
                    return responseEntity;
                }
            }
            TypedQuery roles = this.entityManager.createQuery(QueryTotal, RolesDto.class);
            cuantosregistro = roles.getResultList().size();
            roles.setFirstResult(offsetIn);
            roles.setMaxResults(numofrecordsIn);
            RoleDto role = new RoleDto();
            ArrayList<RoleDto> listacompletaRoles = new ArrayList<RoleDto>();
            List listacompleta = roles.getResultList();
            PrivilegesAllDto detallePrivilege = new PrivilegesAllDto();
            if (this.privilegesRepository.existsById((Object)621)) {
                detallePrivilege.setUpdate(true);
            } else {
                detallePrivilege.setUpdate(false);
            }
            if (this.privilegesRepository.existsById((Object)620)) {
                detallePrivilege.setView(true);
            } else {
                detallePrivilege.setView(false);
            }
            if (this.privilegesRepository.existsById((Object)622)) {
                detallePrivilege.setAdd(true);
            } else {
                detallePrivilege.setAdd(false);
            }
            if (this.privilegesRepository.existsById((Object)623)) {
                detallePrivilege.setDelete(true);
            } else {
                detallePrivilege.setDelete(false);
            }
            for (RolesDto rol : listacompleta) {
                role.setId(rol.getId());
                role.setName(rol.getName());
                listacompletaRoles.add(role);
                role = new RoleDto();
            }
            rolesResponseDto.setNumofrecords(cuantosregistro);
            rolesResponseDto.setRecords(listacompletaRoles);
            rolesResponseDto.setPrivileges(detallePrivilege);
            List lista = (List)this.objectMapper.readValue(entrypoint, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            rolesResponseDto.setEntrypoints(lista);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)rolesResponseDto);
            return responseEntity;
        }
        catch (Exception e) {
            respuesta.setMsg("Error interno del servidor");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        return new ResponseEntity((Object)respuesta, estatus);
    }

    @PostMapping(value={"/roles/{roleid}"})
    public ResponseEntity<?> actualizarRol(HttpServletRequest request, @RequestBody RolNameDto rolName, @PathVariable(value="roleid") Integer roleid) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        String var = "";
        boolean bloked = false;
        RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        RolesResponseDto rolesResponseDto = new RolesResponseDto();
        Long cuantosregistro = 0L;
        ArrayList listasRoles = new ArrayList();
        ArrayList listasPrivelege = new ArrayList();
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        String searchIn = "";
        boolean orderIn = false;
        boolean offsetIn = false;
        boolean numofrecordsIn = false;
        String nameRol = "";
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        if (sessionid == null) {
            respuesta.setMsg("Llamada al servicio malformado");
            return new ResponseEntity((Object)respuesta, HttpStatus.BAD_REQUEST);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var2 = "";
                boolean bloked2 = false;
                RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            if (roleid != 0) {
                boolean existeRol = this.rolesRepository.existsById((Object)roleid);
                if (!existeRol) {
                    respuesta.setMsg("Registro no encontrado");
                    return new ResponseEntity((Object)respuesta, HttpStatus.NOT_FOUND);
                }
                int rolisvalid = 0;
                rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 621);
                if (rolisvalid == 0) {
                    respuesta.setMsg("No tiene los Privilegios");
                    return new ResponseEntity((Object)respuesta, HttpStatus.FORBIDDEN);
                }
                nameRol = ((Roles)this.rolesRepository.findById((Object)roleid).get()).getName();
                String SalidaName = this.usersService.verificarCaracteresValidosConRegex(rolName.getName());
                if (SalidaName == "NOOK") {
                    String var2 = "";
                    boolean bloked2 = false;
                    RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                    respuestaDto.setMsg("Caracteres no permitidos en la busqueda");
                    return new ResponseEntity((Object)respuestaDto2, HttpStatus.BAD_REQUEST);
                }
                if (this.rolesRepository.existsByName(rolName.getName()) && rolName.getName().compareTo(nameRol) != 0) {
                    respuesta.setMsg("Registro duplicado");
                    return new ResponseEntity((Object)respuesta, HttpStatus.CONFLICT);
                }
                Optional rolElegido = this.rolesRepository.findById((Object)roleid);
                Roles rol = new Roles();
                rol.setId(((Roles)rolElegido.get()).getId());
                rol.setName(rolName.getName());
                rol.setCreatedat(((Roles)rolElegido.get()).getCreatedat());
                rol.setModifiedat(fecha2);
                rol.setEntrypoint(rolName.getEntrypoint());
                this.rolesRepository.save((Object)rol);
                String module = "Roles";
                String Descmodule = "Se actualiz\u00f3: " + ((Roles)rolElegido.get()).getName();
                auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                String singo1 = "(";
                String singo2 = ")";
                String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                auditDto.setUserref(usryemail);
                auditDto.setModule(module);
                auditDto.setDesc(Descmodule);
                auditDto.setCreatedat(fechaDate);
                this.usersService.registrarAuditSesion(auditDto);
                RespuestaValueDto respuestaValueDto = new RespuestaValueDto(roleid.intValue());
                estatus = HttpStatus.OK;
                return new ResponseEntity((Object)respuestaValueDto, estatus);
            }
            Roles rol = new Roles();
            if (this.rolesRepository.existsByName(rolName.getName())) {
                respuesta.setMsg("Registro duplicado");
                return new ResponseEntity((Object)respuesta, HttpStatus.CONFLICT);
            }
            int rolisvalid = 0;
            rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 622);
            if (rolisvalid == 0) {
                respuesta.setMsg("No tiene los Privilegios");
                return new ResponseEntity((Object)respuesta, HttpStatus.FORBIDDEN);
            }
            rol.setName(rolName.getName());
            rol.setCreatedat(fecha2);
            rol.setModifiedat(fecha2);
            rol.setEntrypoint(rolName.getEntrypoint());
            Roles rolNuevo = (Roles)this.rolesRepository.save((Object)rol);
            String module = "Roles";
            String Descmodule = "Se agreg\u00f3: " + rolName.getName();
            auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
            String singo1 = "(";
            String singo2 = ")";
            String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
            auditDto.setUserref(usryemail);
            auditDto.setModule(module);
            auditDto.setDesc(Descmodule);
            auditDto.setCreatedat(fechaDate);
            this.usersService.registrarAuditSesion(auditDto);
            RespuestaValueDto respuestaValueDto = new RespuestaValueDto(rolNuevo.getId());
            estatus = HttpStatus.OK;
            return new ResponseEntity((Object)respuestaValueDto, estatus);
        }
        respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
        estatus = HttpStatus.BAD_REQUEST;
        return new ResponseEntity((Object)respuesta, estatus);
    }

    @GetMapping(value={"/roles/{roleid}"})
    public ResponseEntity<?> getOneRol(HttpServletRequest request, @PathVariable(value="roleid") Integer roleid) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        try {
            String var = "";
            boolean bloked = false;
            RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
            RolesResponseDto rolesResponseDto = new RolesResponseDto();
            Long cuantosregistro = 0L;
            ArrayList listasRoles = new ArrayList();
            ArrayList listasPrivelege = new ArrayList();
            String sessionid = request.getHeader("Authorization");
            Date fecha = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dataFormattata = formatter.format(fecha);
            Date fechaDate = formatter.parse(dataFormattata);
            AuditRequestDto auditDto = new AuditRequestDto();
            String searchIn = "";
            boolean orderIn = false;
            boolean offsetIn = false;
            boolean numofrecordsIn = false;
            Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
            String SessionDuration = ((Params)deSessDuration.get()).getValue();
            int duracionSession = Integer.parseInt(SessionDuration);
            Date fecha2 = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fecha2);
            calendar.add(12, duracionSession);
            Date ValidThrufechaSalida = calendar.getTime();
            SimpleDateFormat salida = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String fechaComoCadena = salida.format(ValidThrufechaSalida);
            System.out.println(fechaComoCadena);
            if (sessionid == null) {
                respuesta.setMsg("Llamada al servicio malformado");
                return new ResponseEntity((Object)respuesta, HttpStatus.BAD_REQUEST);
            }
            Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
            if (encontreSessionUsuario.isPresent()) {
                Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
                fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
                if (fechaComoCadena == "") {
                    String var2 = "";
                    boolean bloked2 = false;
                    RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                    respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                    return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
                }
                boolean existeRol = this.rolesRepository.existsById((Object)roleid);
                if (!existeRol) {
                    respuesta.setMsg("Registro no encontrado");
                    return new ResponseEntity((Object)respuesta, HttpStatus.NOT_FOUND);
                }
                int rolisvalid = 0;
                rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 620);
                Optional rolElegido = this.rolesRepository.findById((Object)roleid);
                EntryDto entry = new EntryDto();
                RolesUserDto entry2 = new RolesUserDto();
                entry2.setId(Integer.valueOf(((Roles)rolElegido.get()).getId()));
                entry2.setName(((Roles)rolElegido.get()).getName());
                entry2.setEntrypoint(((Roles)rolElegido.get()).getEntrypoint());
                entry.setEntry(entry2);
                entry.setSessionvalidthru(fechaComoCadena);
                estatus = HttpStatus.OK;
                return new ResponseEntity((Object)entry, estatus);
            }
            respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            estatus = HttpStatus.UNAUTHORIZED;
            return new ResponseEntity((Object)respuesta, estatus);
        }
        catch (Exception e) {
            respuesta.setMsg("Error interno del servidor");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
            return new ResponseEntity((Object)respuesta, estatus);
        }
    }

    @DeleteMapping(value={"/roles/{roleid}"})
    public ResponseEntity<?> borrarRol(HttpServletRequest request, @PathVariable(value="roleid") Integer roleid) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        RolesResponseDto rolesResponseDto = new RolesResponseDto();
        Long cuantosregistro = 0L;
        ArrayList listasRoles = new ArrayList();
        ArrayList listasPrivelege = new ArrayList();
        String var = "";
        boolean bloked = false;
        RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        String searchIn = "";
        String module = "";
        String Descmodule = "";
        boolean orderIn = false;
        boolean offsetIn = false;
        boolean numofrecordsIn = false;
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        if (sessionid == null) {
            respuesta.setMsg("Llamada al servicio malformado");
            estatus = HttpStatus.BAD_REQUEST;
            return new ResponseEntity((Object)respuesta, estatus);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var2 = "";
                boolean bloked2 = false;
                RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            int rolisvalid = 0;
            rolisvalid = this.auditRepository.getCantbyRolAndPrivi(((Users)encontreSessionUsuario.get()).getRolid().getId(), 623);
            if (rolisvalid == 0) {
                respuesta.setMsg("No tiene los Privilegios");
                estatus = HttpStatus.FORBIDDEN;
                return new ResponseEntity((Object)respuesta, estatus);
            }
            try {
                int existeRolUsr = this.usersRepository.existsByRolid(roleid.intValue());
                if (existeRolUsr == 0) {
                    boolean existe = this.rolesRepository.existsById((Object)roleid);
                    if (existe) {
                        this.rolesPrivilegesRepository.borrarRol(roleid.intValue());
                        Optional useradelete = this.rolesRepository.findById((Object)roleid);
                        this.rolesRepository.deleteById((Object)roleid);
                        module = "Roles";
                        Descmodule = " Se elimin\u00f3: " + ((Roles)useradelete.get()).getName();
                        auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                        String singo1 = "(";
                        String singo2 = ")";
                        String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                        auditDto.setUserref(usryemail);
                        auditDto.setModule(module);
                        auditDto.setDesc(Descmodule);
                        auditDto.setCreatedat(fechaDate);
                        this.usersService.registrarAuditSesion(auditDto);
                        RespuestaValueDto respuestaValueDto = new RespuestaValueDto(roleid.intValue());
                        estatus = HttpStatus.OK;
                        return new ResponseEntity((Object)respuestaValueDto, estatus);
                    }
                    respuesta.setMsg("Registro no encontrado");
                    estatus = HttpStatus.NOT_FOUND;
                    return new ResponseEntity((Object)respuesta, estatus);
                }
                respuesta.setMsg("Error de Dependencias");
                estatus = HttpStatus.CONFLICT;
                return new ResponseEntity((Object)respuesta, estatus);
            }
            catch (Exception e) {
                respuesta.setMsg("Error interno del servidor");
                estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                return new ResponseEntity((Object)respuesta, estatus);
            }
        }
        respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
        estatus = HttpStatus.UNAUTHORIZED;
        return new ResponseEntity((Object)respuesta, estatus);
    }
}

