/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.security.dto.AuditRequestDto;
import com.dacrt.SBIABackend.security.dto.ParamsDto;
import com.dacrt.SBIABackend.security.dto.ParamsResponseDto;
import com.dacrt.SBIABackend.security.dto.PrivilegesDto;
import com.dacrt.SBIABackend.security.dto.RespuestaDto;
import com.dacrt.SBIABackend.security.dto.RespuestaMsgDto;
import com.dacrt.SBIABackend.security.dto.RespuestaValueDto;
import com.dacrt.SBIABackend.security.dto.UsersListDto;
import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.entity.Roles;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.AuditRepository;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import com.dacrt.SBIABackend.security.service.MenuService;
import com.dacrt.SBIABackend.security.service.ParamsService;
import com.dacrt.SBIABackend.security.service.SecurityService;
import com.dacrt.SBIABackend.security.service.UsersService;
import com.dacrt.SBIABackend.utils.HttpReqRespUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
@CrossOrigin(origins={"*"})
public class SystemController {
    @Autowired
    private ParamsRepository paramsRepository;
    @Autowired
    private UsersRepository usersRepository;
    @Autowired
    private AuditRepository auditRepository;
    @Autowired
    UsersService usersService;
    @Autowired
    ParamsService paramsService;
    @Autowired
    MenuService menuService;
    @Autowired
    SecurityService securityService;
    @Autowired
    private ObjectMapper objectMapper;
    @PersistenceContext
    private EntityManager entityManager;
    Logger logger = LoggerFactory.getLogger(SystemController.class);

    @PostMapping(value={"/params/{parmid}"})
    public ResponseEntity<ParamsResponseDto> paramsUpdate(HttpServletRequest request, @RequestBody ParamsDto tiposfiltros, @PathVariable(value="parmid") Integer parmid) throws ParseException {
        int idparametro;
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        ParamsResponseDto paramsResponseDto = new ParamsResponseDto();
        ArrayList listasParams = new ArrayList();
        ArrayList listasPrivelege = new ArrayList();
        int valor = idparametro = parmid.intValue();
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        if (sessionid == null) {
            String var = "";
            boolean bloked = false;
            RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
            respuestaDto.setMsg("Llamada al servicio malformado");
            return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            Roles roles = ((Users)encontreSessionUsuario.get()).getRolid();
            int idrol = roles.getId();
            int rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 611);
            if (rolisvalid == 0) {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("No tiene los Privilegios");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.FORBIDDEN);
            }
            boolean existeParam = this.paramsService.existsById(parmid);
            if (!existeParam) {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Registro no encontrado");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.NOT_FOUND);
            }
        } else {
            String var = "";
            boolean bloked = false;
            RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
            respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
        }
        String module = "Par\u00e1metros";
        Optional paraactualiza = this.paramsRepository.findById((Object)parmid);
        String Descmodule = "Se actualiz\u00f3 el parametro : " + ((Params)paraactualiza.get()).getParamname();
        auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
        String singo1 = "(";
        String singo2 = ")";
        String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
        auditDto.setUserref(usryemail);
        auditDto.setModule(module);
        auditDto.setDesc(Descmodule);
        auditDto.setCreatedat(fechaDate);
        this.usersService.registrarAuditSesion(auditDto);
        try {
            Params tipoParams = this.paramsService.getParamsByid(parmid);
            tipoParams.setValue(tiposfiltros.getValue());
            tipoParams.setGroup(tipoParams.getGroup());
            tipoParams.setInfo(tipoParams.getInfo());
            tipoParams.setModifiedat(fechaDate);
            tipoParams.setName(tipoParams.getName());
            tipoParams.setParamname(tipoParams.getParamname());
            tipoParams.setType(tipoParams.getType());
            Params tipoParams2 = this.paramsService.addIdParams(tipoParams);
            if (tipoParams2 != null) {
                RespuestaValueDto respuestaValueDto = new RespuestaValueDto(parmid.intValue());
                estatus = HttpStatus.OK;
                return new ResponseEntity((Object)respuestaValueDto, estatus);
            }
            respuesta = new RespuestaMsgDto("Fallo la actualizacion");
            estatus = HttpStatus.BAD_REQUEST;
            return new ResponseEntity((Object)respuesta, estatus);
        }
        catch (Exception e) {
            respuesta = new RespuestaMsgDto("Error interno del servidor");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
            return new ResponseEntity((Object)respuesta, estatus);
        }
    }

    @PostMapping(value={"/params"})
    public ResponseEntity<ParamsResponseDto> params(HttpServletRequest request, @RequestBody UsersListDto tiposfiltros) throws ParseException {
        String fechaComoCadena;
        RespuestaDto respuesta = new RespuestaDto("", false);
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        ParamsResponseDto paramsResponseDto = new ParamsResponseDto();
        Long cuantosregistro = 0L;
        ArrayList listasParams = new ArrayList();
        ArrayList listasPrivelege = new ArrayList();
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        String searchIn = "";
        String searchModule = "";
        String searchUsr = "";
        String contentIn = "";
        int orderIn = 0;
        int offsetIn = 0;
        int numofrecordsIn = 0;
        Date fecha2 = new Date();
        if (sessionid == null) {
            String var = "";
            boolean bloked = false;
            RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
            respuestaDto.setBlocked(bloked);
            respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            Roles roles = ((Users)encontreSessionUsuario.get()).getRolid();
            int idrol = roles.getId();
            int rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 610);
            if (rolisvalid == 0) {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("No tiene los Privilegios");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.FORBIDDEN);
            }
            searchIn = tiposfiltros.getFilters().getSearch();
            String Salida = this.usersService.verificarCaracteresValidosConRegex(searchIn);
            if (Salida == "NOOK") {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Caracteres no permitidos en la busqueda");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
            }
            searchIn = this.eliminarAcentos(tiposfiltros.getFilters().getSearch());
            searchModule = tiposfiltros.getFilters().getModule();
            searchUsr = tiposfiltros.getFilters().getUser();
            orderIn = tiposfiltros.getOrder();
            offsetIn = tiposfiltros.getOffset();
            numofrecordsIn = tiposfiltros.getNumofrecords();
            contentIn = tiposfiltros.getContent();
            if (contentIn != null) {
                this.menuService.iscontentdiffnull(contentIn, ((Users)encontreSessionUsuario.get()).getId());
            }
        } else {
            String var = "";
            boolean bloked = false;
            RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
            respuestaDto.setBlocked(bloked);
            respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
        }
        try {
            String SentenciaBase = "SELECT new com.dacrt.SBIABackend.security.dto.ParamsDto (u.id, u.paramname,u.group,u.name,u.type,u.value,u.info,u.modifiedat) FROM Params u";
            String QueryTotal = "";
            String name = "u.name";
            String group = "u.group";
            String lowerparam = "main.sinacentos(LOWER(u.paramname))";
            String lowername = "main.sinacentos(LOWER(u.name))";
            String lowergroup = "main.sinacentos(LOWER(u.group))";
            String LowerSearch = searchIn.toLowerCase();
            switch (searchIn) {
                case "": {
                    QueryTotal = String.valueOf(SentenciaBase) + " WHERE " + "TRUE = TRUE";
                    break;
                }
                default: {
                    QueryTotal = String.valueOf(SentenciaBase) + " WHERE " + lowerparam + " LIKE  " + "'%" + LowerSearch + "%'" + " OR " + lowername + " LIKE " + "'%" + LowerSearch + "%'" + " OR " + lowergroup + " LIKE " + "'%" + LowerSearch + "%'";
                }
            }
            TypedQuery paramsCount = this.entityManager.createQuery(QueryTotal, ParamsDto.class);
            cuantosregistro = paramsCount.getResultList().size();
            String ordena = "";
            if (orderIn == 1 || orderIn == 2 || orderIn == 3) {
                ordena = " ASC";
            } else if (orderIn == -1 || orderIn == -2 || orderIn == -3) {
                ordena = " DESC";
            } else {
                String var2 = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var2);
                respuestaDto = new RespuestaMsgDto("Error interno del servidor");
                estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, estatus);
                return responseEntity;
            }
            int absolutoOrden = Math.abs(orderIn);
            switch (absolutoOrden) {
                case 1: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + group + ordena + "," + name + ordena;
                    break;
                }
                case 2: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + group + ordena;
                    break;
                }
                case 3: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + name + ordena;
                }
            }
            TypedQuery params = this.entityManager.createQuery(QueryTotal, ParamsDto.class);
            params.setFirstResult(offsetIn);
            params.setMaxResults(numofrecordsIn);
            List listacompleta = params.getResultList();
            PrivilegesDto detallePrivilege = new PrivilegesDto();
            detallePrivilege.setUpdate(true);
            detallePrivilege.setView(true);
            paramsResponseDto.setNumofrecords(cuantosregistro);
            paramsResponseDto.setValidthru(fechaComoCadena);
            paramsResponseDto.setRecords(listacompleta);
            paramsResponseDto.setPrivileges(detallePrivilege);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)paramsResponseDto);
            return responseEntity;
        }
        catch (Exception e) {
            respuesta = new RespuestaDto("Error interno del servidor", false);
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        return new ResponseEntity((Object)respuesta, estatus);
    }

    public String arrayAParentesis(List<Integer> lista) {
        if (lista == null || lista.isEmpty()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while (i < lista.size()) {
            sb.append(lista.get(i));
            if (i < lista.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String eliminarAcentos(String texto) {
        String normalized = Normalizer.normalize(texto, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("[^\\p{ASCII}]");
        return pattern.matcher(normalized).replaceAll("");
    }
}

