/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.controler;

import com.dacrt.SBIABackend.dto.StatusDto;
import com.dacrt.SBIABackend.dto.UnitsDto;
import com.dacrt.SBIABackend.entity.Suppliers;
import com.dacrt.SBIABackend.entity.Units;
import com.dacrt.SBIABackend.entity.Userunits;
import com.dacrt.SBIABackend.entity.Workers;
import com.dacrt.SBIABackend.repository.SuppliersRepository;
import com.dacrt.SBIABackend.repository.UnitsRepository;
import com.dacrt.SBIABackend.repository.UserunitsRepository;
import com.dacrt.SBIABackend.repository.WorkersRepository;
import com.dacrt.SBIABackend.security.dto.AuditRequestDto;
import com.dacrt.SBIABackend.security.dto.ParamsResponseDto;
import com.dacrt.SBIABackend.security.dto.PrivilegesAllDto;
import com.dacrt.SBIABackend.security.dto.RespuestaDto;
import com.dacrt.SBIABackend.security.dto.RespuestaMsgDto;
import com.dacrt.SBIABackend.security.dto.RespuestaValueDto;
import com.dacrt.SBIABackend.security.dto.RolesResponseDto;
import com.dacrt.SBIABackend.security.dto.RolesUserDto;
import com.dacrt.SBIABackend.security.dto.SuppliersUsersDto;
import com.dacrt.SBIABackend.security.dto.UserDetailsResponseDto;
import com.dacrt.SBIABackend.security.dto.UserRequestNewDto;
import com.dacrt.SBIABackend.security.dto.UsersListDto;
import com.dacrt.SBIABackend.security.dto.UsersListResponseDto;
import com.dacrt.SBIABackend.security.dto.UsersRolesPriWorStaDto;
import com.dacrt.SBIABackend.security.dto.UsersUnitDto;
import com.dacrt.SBIABackend.security.dto.WorkersUsersDto;
import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.entity.Roles;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.AuditRepository;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.RolesPrivilegesRepository;
import com.dacrt.SBIABackend.security.repository.RolesRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import com.dacrt.SBIABackend.security.service.MenuService;
import com.dacrt.SBIABackend.security.service.RolesService;
import com.dacrt.SBIABackend.security.service.SecurityService;
import com.dacrt.SBIABackend.security.service.UsersService;
import com.dacrt.SBIABackend.service.SuppliersService;
import com.dacrt.SBIABackend.service.WorkersService;
import com.dacrt.SBIABackend.utils.HttpReqRespUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class UsersController {
    @Autowired
    AuthenticationManager autheticationManager;
    @Autowired
    PasswordEncoder passworEncoder;
    @Autowired
    UsersService usersService;
    @Autowired
    MenuService menuService;
    @Autowired
    RolesService rolesService;
    @Autowired
    UsersRepository usersRepository;
    @Autowired
    ParamsRepository paramsRepository;
    @Autowired
    AuditRepository auditRepository;
    @Autowired
    UserunitsRepository userunitsRepository;
    @Autowired
    UnitsRepository unitsRepository;
    @Autowired
    WorkersRepository workersRepository;
    @Autowired
    SuppliersRepository suppliersRepository;
    @Autowired
    RolesPrivilegesRepository rolesPrivilegesRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    WorkersService workersService;
    @Autowired
    SecurityService securityService;
    @Autowired
    RolesRepository rolesRepository;
    @Autowired
    SuppliersService suppliersService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${var.ambiente}")
    private String urlAmbiente;
    @Value(value="${spring.datasource.url}")
    private String conexion;
    @Value(value="${spring.datasource.username}")
    private String userbd;
    @Value(value="${spring.datasource.password}")
    private String passbd;
    Logger logger = LoggerFactory.getLogger(UsersController.class);
    Date fechaActual = new Date();

    @PostMapping(value={"/users"})
    public ResponseEntity<UsersListResponseDto> userlist(HttpServletRequest request, @RequestBody UsersListDto tiposfiltros) throws ParseException {
        String sessionid = request.getHeader("Authorization");
        UsersListResponseDto usersResponseDto = new UsersListResponseDto();
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        int statusIn = tiposfiltros.getFilters().getStatus();
        int roleIn = tiposfiltros.getFilters().getRole();
        String searchIn = tiposfiltros.getFilters().getSearch();
        int orderIn = tiposfiltros.getOrder();
        int offsetIn = tiposfiltros.getOffset();
        int numofrecordsIn = tiposfiltros.getNumofrecords();
        ArrayList<UsersRolesPriWorStaDto> listasUsersRolesPriWorStaDto = new ArrayList<UsersRolesPriWorStaDto>();
        StatusDto detalleStatus = new StatusDto();
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        Long cuantosregistro = 0L;
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        try {
            int idrol;
            String fechaComoCadena;
            String searchModule = "";
            String searchUsr = "";
            String contentIn = "";
            int searchStatus = 0;
            boolean searchRoles = false;
            if (sessionid == null) {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
            if (encontreSessionUsuario.isPresent()) {
                Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
                fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
                if (fechaComoCadena == "") {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
                    return responseEntity;
                }
                Roles roles = ((Users)encontreSessionUsuario.get()).getRolid();
                idrol = roles.getId();
                int rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 630);
                if (rolisvalid == 0) {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("No tiene los Privilegios");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.FORBIDDEN);
                    return responseEntity;
                }
                searchIn = tiposfiltros.getFilters().getSearch();
                String Salida = this.usersService.verificarCaracteresValidosConRegex(searchIn);
                if (Salida == "NOOK") {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Caracteres no permitidos en la busqueda");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
                    return responseEntity;
                }
                searchIn = this.usersService.eliminarAcentosService(tiposfiltros.getFilters().getSearch());
                searchModule = tiposfiltros.getFilters().getModule();
                searchUsr = tiposfiltros.getFilters().getUser();
                searchStatus = tiposfiltros.getFilters().getStatus();
                orderIn = tiposfiltros.getOrder();
                offsetIn = tiposfiltros.getOffset();
                numofrecordsIn = tiposfiltros.getNumofrecords();
                contentIn = tiposfiltros.getContent();
                if (contentIn != null) {
                    this.menuService.iscontentdiffnull(contentIn, ((Users)encontreSessionUsuario.get()).getId());
                }
            } else {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
                return responseEntity;
            }
            String SentenciaBase = "SELECT u.id,u.usr,u.name,u.email,u.rolid,u.workerid,u.supplierid,u.status FROM main.users u";
            String QueryTotal = "";
            String lowername = "LOWER(u.dsc)";
            String LowerSearch = searchIn.toLowerCase();
            switch (searchIn) {
                case "": {
                    QueryTotal = String.valueOf(SentenciaBase) + " WHERE " + "TRUE = TRUE";
                    break;
                }
                default: {
                    QueryTotal = String.valueOf(SentenciaBase) + " WHERE " + " main.sinacentos(LOWER(u.usr))" + " LIKE  " + "'%" + LowerSearch + "%'" + " OR " + " main.sinacentos(LOWER(u.name)) " + " LIKE  " + "'%" + LowerSearch + "%'" + " OR " + " main.sinacentos(LOWER(u.email))" + " LIKE  " + "'%" + LowerSearch + "%'";
                }
            }
            switch (roleIn) {
                case 0: {
                    break;
                }
                default: {
                    QueryTotal = String.valueOf(QueryTotal) + " AND " + "u.rolid = " + roleIn;
                }
            }
            switch (searchStatus) {
                case 0: {
                    break;
                }
                case 1: {
                    QueryTotal = String.valueOf(QueryTotal) + " AND " + "u.status" + " = " + searchStatus;
                    break;
                }
                case 2: {
                    QueryTotal = String.valueOf(QueryTotal) + " AND " + "u.status" + " = " + 0;
                    break;
                }
                default: {
                    String var2 = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var2);
                    respuestaDto = new RespuestaMsgDto("Error interno del servidor");
                    estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, estatus);
                    return responseEntity;
                }
            }
            cuantosregistro = this.jdbcTemplate.queryForList(QueryTotal).size();
            String ordena = "";
            if (orderIn == 1 || orderIn == 2 || orderIn == 3 || orderIn == 4 || orderIn == 5 || orderIn == 6) {
                ordena = " ASC";
            } else if (orderIn == -1 || orderIn == -2 || orderIn == -3 || orderIn == -4 || orderIn == -5 || orderIn == -6) {
                ordena = " DESC";
            } else {
                String var2 = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var2);
                respuestaDto = new RespuestaMsgDto("Error interno del servidor");
                estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, estatus);
                return responseEntity;
            }
            int absolutoOrden = Math.abs(orderIn);
            switch (absolutoOrden) {
                case 1: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + "u.createdat" + ordena;
                    break;
                }
                case 2: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + "u.name" + ordena;
                    break;
                }
                case 3: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + "u.usr" + ordena;
                    break;
                }
                case 4: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + "u.email" + ordena;
                    break;
                }
                case 5: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + "u.rolid" + ordena;
                    break;
                }
                case 6: {
                    QueryTotal = String.valueOf(QueryTotal) + " ORDER BY " + "u.status" + ordena;
                }
            }
            QueryTotal = String.valueOf(QueryTotal) + " LIMIT " + numofrecordsIn + " OFFSET " + offsetIn;
            List lista = this.jdbcTemplate.queryForList(QueryTotal);
            WorkersUsersDto detalleworker = new WorkersUsersDto();
            SuppliersUsersDto detallesupplier = new SuppliersUsersDto();
            RolesUserDto detalleroles = new RolesUserDto();
            detalleStatus = new StatusDto();
            PrivilegesAllDto detallePrivilege = new PrivilegesAllDto();
            boolean tieneView = this.rolesPrivilegesRepository.existsByRolidAndPrivilegeid(idrol, Integer.valueOf(630));
            boolean tieneUpdate = this.rolesPrivilegesRepository.existsByRolidAndPrivilegeid(idrol, Integer.valueOf(631));
            boolean tieneAdd = this.rolesPrivilegesRepository.existsByRolidAndPrivilegeid(idrol, Integer.valueOf(632));
            boolean tieneDelete = this.rolesPrivilegesRepository.existsByRolidAndPrivilegeid(idrol, Integer.valueOf(633));
            detallePrivilege.setView(tieneView);
            detallePrivilege.setUpdate(tieneUpdate);
            detallePrivilege.setAdd(tieneAdd);
            detallePrivilege.setDelete(tieneDelete);
            for (Map mapa : lista) {
                String descestatus;
                ArrayList<StatusDto> listasStatus = new ArrayList<StatusDto>();
                ArrayList<WorkersUsersDto> listasWorkersUsersDto = new ArrayList<WorkersUsersDto>();
                ArrayList<SuppliersUsersDto> listasSuppliersUsersDto = new ArrayList<SuppliersUsersDto>();
                ArrayList<RolesUserDto> listasRolesUsersDto = new ArrayList<RolesUserDto>();
                UsersRolesPriWorStaDto detalleUsers = new UsersRolesPriWorStaDto();
                detalleStatus = new StatusDto();
                detalleworker = new WorkersUsersDto();
                detallesupplier = new SuppliersUsersDto();
                detalleroles = new RolesUserDto();
                int id = (Integer)mapa.get("id");
                String usr = (String)mapa.get("usr");
                String name = (String)mapa.get("name");
                String email = (String)mapa.get("email");
                int rolid = (Integer)mapa.get("rolid");
                int status = (Integer)mapa.get("status");
                detalleUsers.setId(Integer.valueOf(id));
                detalleUsers.setUsr(usr);
                detalleUsers.setName(name);
                detalleUsers.setEmail(email);
                try {
                    int workerid = (Integer)mapa.get("workerid");
                    Optional worker = this.workersRepository.findById(workerid);
                    detalleworker.setId(((Workers)worker.get()).getId());
                    detalleworker.setName(((Workers)worker.get()).getName());
                }
                catch (Exception e) {
                    detalleworker.setId(Integer.valueOf(0));
                    detalleworker.setName("");
                }
                listasWorkersUsersDto.add(detalleworker);
                try {
                    int supplierid = (Integer)mapa.get("supplierid");
                    Optional supply = this.suppliersRepository.findById(supplierid);
                    detallesupplier.setId(((Suppliers)supply.get()).getId());
                    detallesupplier.setName(((Suppliers)supply.get()).getName());
                }
                catch (Exception e) {
                    detallesupplier.setId(Integer.valueOf(0));
                    detallesupplier.setName("");
                }
                listasSuppliersUsersDto.add(detallesupplier);
                detalleStatus.setId(Integer.valueOf(status));
                if (status == 1) {
                    descestatus = "Activo";
                    detalleStatus.setName(descestatus);
                } else {
                    descestatus = "Inactivo";
                    detalleStatus.setName(descestatus);
                }
                listasStatus.add(detalleStatus);
                Optional rolesOnly = this.rolesRepository.findById(rolid);
                detalleroles.setId(Integer.valueOf(((Roles)rolesOnly.get()).getId()));
                detalleroles.setName(((Roles)rolesOnly.get()).getName());
                listasRolesUsersDto.add(detalleroles);
                detalleUsers.setWorker(detalleworker);
                detalleUsers.setSupplier(detallesupplier);
                detalleUsers.setStatus(detalleStatus);
                detalleUsers.setRole(detalleroles);
                listasUsersRolesPriWorStaDto.add(detalleUsers);
            }
            usersResponseDto.setNumofrecords(cuantosregistro);
            usersResponseDto.setSessionvalidthru(fechaComoCadena);
            usersResponseDto.setRecords(listasUsersRolesPriWorStaDto);
            usersResponseDto.setPrivileges(detallePrivilege);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)usersResponseDto);
            return responseEntity;
        }
        catch (Exception e) {
            String var = e.getMessage();
            boolean bloked = false;
            RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
            respuestaDto.setMsg("Error interno del servidor");
            respuestaDto.setMsg(var);
            ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
    }

    @PostMapping(value={"/users/{userid}"})
    public ResponseEntity<ParamsResponseDto> usersUpdate(HttpServletRequest request, @RequestBody UserRequestNewDto datosUsuario, @PathVariable(value="userid") Integer userid) throws ParseException, UnsupportedEncodingException {
        int idparametro;
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        ParamsResponseDto paramsResponseDto = new ParamsResponseDto();
        ArrayList listasParams = new ArrayList();
        ArrayList listasPrivelege = new ArrayList();
        int valor = idparametro = userid.intValue();
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        Optional deMinLength = this.paramsRepository.findByParamname("PWD_MINLENGTH");
        String minlongitud = ((Params)deMinLength.get()).getValue();
        Optional deSimbolos = this.paramsRepository.findByParamname("PWD_SYMBOLS");
        String cantSimbolos = ((Params)deSimbolos.get()).getValue();
        Optional deCantMayus = this.paramsRepository.findByParamname("PWD_UPPERCASE");
        String cantMayusculas = ((Params)deCantMayus.get()).getValue();
        Optional deCantMinus = this.paramsRepository.findByParamname("PWD_LOWERCASE");
        String cantMinusculas = ((Params)deCantMinus.get()).getValue();
        Optional desimbolosPer = this.paramsRepository.findByParamname("PWD_ALLOWEDSYM");
        String simbolospermi = ((Params)desimbolosPer.get()).getValue();
        String encoding = StandardCharsets.UTF_8.toString();
        String caracteresCodificados = URLEncoder.encode(simbolospermi, encoding);
        Optional deCarateresPer = this.paramsRepository.findByParamname("NICK_ALLOWEDSYM");
        String caracterespermi = ((Params)deCarateresPer.get()).getValue();
        String encoding2 = StandardCharsets.UTF_8.toString();
        String caracteresCodificados2 = URLEncoder.encode(caracterespermi, encoding2);
        if (sessionid == null) {
            String var = "";
            boolean bloked = false;
            RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
            respuestaDto.setMsg("Llamada al servicio malformado");
            return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            int rolisvalid;
            int idrol;
            Roles roles;
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            if (idparametro == 0) {
                roles = ((Users)encontreSessionUsuario.get()).getRolid();
                idrol = roles.getId();
                rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 632);
                if (rolisvalid == 0) {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("No tiene los Privilegios");
                    return new ResponseEntity((Object)respuestaDto, HttpStatus.FORBIDDEN);
                }
            } else {
                roles = ((Users)encontreSessionUsuario.get()).getRolid();
                idrol = roles.getId();
                rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 631);
                if (rolisvalid == 0) {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("No tiene los Privilegios");
                    return new ResponseEntity((Object)respuestaDto, HttpStatus.FORBIDDEN);
                }
            }
            String SalidaName = this.usersService.verificarCaracteresValidosConRegex(datosUsuario.getName());
            String SalidaUsu = this.usersService.verificarCaracteresValidosConRegex(datosUsuario.getUsr());
            String Salidaemail = this.usersService.verificarCaracteresValidosConRegex(datosUsuario.getEmail());
            if (SalidaName == "NOOK" || SalidaUsu == "NOOK" || Salidaemail == "NOOK") {
                String var = "";
                boolean bloked = false;
                RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                respuestaDto.setMsg("Caracteres no permitidos en la busqueda");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
            }
            if (idparametro == 0) {
                int existeEmpleadoUser;
                if (datosUsuario.getWorkerid() != 0 && (existeEmpleadoUser = this.usersRepository.consultarUsuWorkers(Integer.valueOf(datosUsuario.getWorkerid()))) > 0) {
                    String var = "";
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Registro Duplicado");
                    return new ResponseEntity((Object)respuestaDto, HttpStatus.CONFLICT);
                }
            } else {
                boolean existeUser = this.usersRepository.existsById(idparametro);
                if (!existeUser) {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Registro no encontrado");
                    return new ResponseEntity((Object)respuestaDto, HttpStatus.NOT_FOUND);
                }
            }
            int i = 0;
            while (i < datosUsuario.getUsr().length()) {
                char currentChar = datosUsuario.getUsr().charAt(i);
                if (caracterespermi.indexOf(currentChar) == -1) {
                    String var = "";
                    boolean bloked = false;
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Caracteres no permitidos en el Nombre del Usuario");
                    return new ResponseEntity((Object)respuestaDto, HttpStatus.BAD_REQUEST);
                }
                ++i;
            }
        } else {
            String var = "";
            boolean bloked = false;
            RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
            respuestaDto.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
        }
        try {
            Users tipoUsers2 = null;
            Users tipoUsers = null;
            Users tipoUsersNew2 = null;
            Optional nuevoinsertado = null;
            Userunits tipoUsersUnits = new Userunits();
            if (idparametro == 0) {
                String ConcatAmbienteLogo;
                Roles tipoRol;
                Users tipoUsersNew = new Users();
                tipoUsersNew.setStatus(datosUsuario.getStatus());
                tipoUsersNew.setName(datosUsuario.getName());
                boolean validaemail = this.usersRepository.existsByEmail(datosUsuario.getEmail());
                boolean validaUser = this.usersRepository.existsByUsr(datosUsuario.getUsr());
                if (validaUser) {
                    String var = "";
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Registro Duplicado");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.CONFLICT);
                    return responseEntity;
                }
                tipoUsersNew.setUsr(datosUsuario.getUsr());
                if (validaemail) {
                    String var = "";
                    RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                    respuestaDto.setMsg("Registro Duplicado");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.CONFLICT);
                    return responseEntity;
                }
                tipoUsersNew.setEmail(datosUsuario.getEmail());
                tipoUsersNew.setModifiedat(fechaDate);
                tipoUsersNew.setCreatedat(fechaDate);
                tipoUsersNew.setLastpwdchange(fechaDate);
                tipoUsersNew.setFails(0);
                tipoUsersNew.setLastsession(fechaDate);
                if (datosUsuario.getRoleid() != 0) {
                    tipoRol = this.rolesService.getRolesByid(Integer.valueOf(datosUsuario.getRoleid()));
                    tipoUsersNew.setRolid(tipoRol);
                } else {
                    tipoRol = this.rolesService.getRolesByid(Integer.valueOf(datosUsuario.getRoleid()));
                    tipoUsersNew.setRolid(tipoRol);
                }
                if (datosUsuario.getWorkerid() != 0) {
                    Workers tipoWorkers = this.workersService.getWorkersByid(Integer.valueOf(datosUsuario.getWorkerid()));
                    tipoUsersNew.setWorkerid(tipoWorkers);
                }
                if (datosUsuario.getSupplierid() != 0) {
                    Suppliers tipoSuppliers = this.suppliersService.getSuppliersByid(Integer.valueOf(datosUsuario.getSupplierid()));
                    tipoUsersNew.setSupplierid(tipoSuppliers);
                }
                String jwt = UUID.randomUUID().toString();
                tipoUsersNew.setSessionid(jwt);
                tipoUsers2 = tipoUsersNew2 = this.usersService.addIdUsers(tipoUsersNew);
                String saludo = " Por favor ingresa en el siguiente enlace para definir  tu clave y completar tu registro en el sistema:";
                String accion = "Registrar";
                String idcampo = "?sid=";
                String ConcatAmbiente = String.valueOf(this.urlAmbiente) + idcampo;
                String idcampoLogo = "img/logo.png";
                String ruta = ConcatAmbienteLogo = String.valueOf(this.urlAmbiente) + idcampoLogo;
                String module = "Usuarios";
                String Descmodule = "Se agreg\u00f3 a: " + datosUsuario.getEmail();
                auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                String singo1 = "(";
                String singo2 = ")";
                String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                auditDto.setUserref(usryemail);
                auditDto.setModule(module);
                auditDto.setDesc(Descmodule);
                auditDto.setCreatedat(fechaDate);
                this.usersService.registrarAuditSesion(auditDto);
                String url = String.valueOf(ConcatAmbiente) + "changepwd" + "&" + "hash" + "=" + jwt + "&" + "email" + "=" + datosUsuario.getEmail() + "&" + "conditions" + "=" + ((Params)deMinLength.get()).getParamname() + ":%20" + minlongitud + "|" + ((Params)deSimbolos.get()).getParamname() + ":%20" + cantSimbolos + "|" + ((Params)deCantMayus.get()).getParamname() + ":%20" + cantMayusculas + "|" + ((Params)deCantMinus.get()).getParamname() + ":%20" + cantMinusculas + "|" + ((Params)desimbolosPer.get()).getParamname() + ":%20" + caracteresCodificados;
                String contenido = this.usersService.ArmarBodySendMailUser(ConcatAmbienteLogo, datosUsuario.getName(), saludo, url, accion, minlongitud, cantMayusculas, cantMinusculas, cantSimbolos, simbolospermi);
                this.usersService.sendEmail(datosUsuario.getEmail(), contenido, "Bienvenido al sistema GCN");
            } else {
                Roles tipoRol;
                String correo2;
                String correo1;
                tipoUsers = this.usersService.getUsersByid(Integer.valueOf(idparametro));
                tipoUsers.setStatus(datosUsuario.getStatus());
                String user1 = tipoUsers.getUsr();
                String user2 = datosUsuario.getUsr();
                if (user1.equals(user2)) {
                    String validaUser = "El user es el mismo";
                } else {
                    boolean validaUser = this.usersRepository.existsByUsr(datosUsuario.getUsr());
                    if (validaUser) {
                        String var = "";
                        RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                        respuestaDto.setMsg("Registro Duplicado");
                        ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.CONFLICT);
                        return responseEntity;
                    }
                    tipoUsers.setUsr(datosUsuario.getUsr());
                }
                tipoUsers.setName(datosUsuario.getName());
                int workers1 = 0;
                try {
                    workers1 = tipoUsers.getWorkerid().getId();
                }
                catch (Exception e) {
                    workers1 = 0;
                }
                int workers2 = datosUsuario.getWorkerid();
                if (workers2 != 0) {
                    if (workers1 == workers2) {
                        String respuestaDto = "El id workers es el mismo";
                    } else {
                        int existeEmpleadoUser = this.usersRepository.consultarUsuWorkers(Integer.valueOf(datosUsuario.getWorkerid()));
                        if (existeEmpleadoUser > 0) {
                            String var = "";
                            RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                            respuestaDto.setMsg("Registro Duplicado");
                            ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.CONFLICT);
                            return responseEntity;
                        }
                    }
                }
                if ((correo1 = tipoUsers.getEmail()).equals(correo2 = datosUsuario.getEmail())) {
                    String respuestaDto = "El email es el mismo";
                } else {
                    boolean validaemail = this.usersRepository.existsByEmail(datosUsuario.getEmail());
                    if (validaemail) {
                        String var = "";
                        RespuestaMsgDto respuestaDto = new RespuestaMsgDto(var);
                        respuestaDto.setMsg("Registro Duplicado");
                        ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.CONFLICT);
                        return responseEntity;
                    }
                    tipoUsers.setEmail(datosUsuario.getEmail());
                }
                tipoUsers.setModifiedat(fechaDate);
                tipoUsers.setFails(0);
                if (datosUsuario.getRoleid() != 0) {
                    tipoRol = this.rolesService.getRolesByid(Integer.valueOf(datosUsuario.getRoleid()));
                    tipoUsers.setRolid(tipoRol);
                } else {
                    tipoRol = this.rolesService.getRolesByid(Integer.valueOf(datosUsuario.getRoleid()));
                    tipoUsers.setRolid(tipoRol);
                }
                if (datosUsuario.getWorkerid() != 0) {
                    Workers tipoWorkers = this.workersService.getWorkersByid(Integer.valueOf(datosUsuario.getWorkerid()));
                    tipoUsers.setWorkerid(tipoWorkers);
                } else {
                    this.usersRepository.updateWorkeridbyId(Integer.valueOf(idparametro));
                }
                if (datosUsuario.getSupplierid() != 0) {
                    Suppliers tipoSuppliers = this.suppliersService.getSuppliersByid(Integer.valueOf(datosUsuario.getSupplierid()));
                    tipoUsers.setSupplierid(tipoSuppliers);
                } else {
                    this.usersRepository.updateSuppliersidbyId(Integer.valueOf(idparametro));
                }
                tipoUsers2 = this.usersService.addIdUsers(tipoUsers);
                String module = "Usuarios";
                String Descmodule = "Se actualiz\u00f3 a: " + datosUsuario.getEmail();
                auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                String singo1 = "(";
                String singo2 = ")";
                String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                auditDto.setUserref(usryemail);
                auditDto.setModule(module);
                auditDto.setDesc(Descmodule);
                auditDto.setCreatedat(fechaDate);
                this.usersService.registrarAuditSesion(auditDto);
                if (datosUsuario.getWorkerid() == 0) {
                    this.usersRepository.updateWorkeridbyId(Integer.valueOf(idparametro));
                }
                if (datosUsuario.getSupplierid() == 0) {
                    this.usersRepository.updateSuppliersidbyId(Integer.valueOf(idparametro));
                }
            }
            int idmensaje = 0;
            if (idparametro != 0) {
                try {
                    this.userunitsRepository.borrarUsersUnits(tipoUsers.getId());
                    idmensaje = userid;
                    Connection conexion2 = DriverManager.getConnection(this.conexion, this.userbd, this.passbd);
                    Statement sentenciaPreparada = null;
                    sentenciaPreparada = conexion2.createStatement();
                    int cuantasuni = datosUsuario.getUnits().size();
                    if (cuantasuni > 0) {
                        String unidades = this.arrayAParentesis(datosUsuario.getUnits());
                        String sql = "INSERT INTO main.userunits (unitid,userid) SELECT id," + userid + " FROM main.units  WHERE id IN " + unidades;
                        sentenciaPreparada.execute(sql);
                    }
                }
                catch (Exception e) {
                    respuesta = new RespuestaMsgDto("Error borrando la relacion Unidades Usuarios");
                    estatus = HttpStatus.CONFLICT;
                }
            } else {
                int idInsertado;
                nuevoinsertado = this.usersRepository.findByEmail(datosUsuario.getEmail());
                idmensaje = idInsertado = ((Users)nuevoinsertado.get()).getId();
                Connection conexion2 = DriverManager.getConnection(this.conexion, this.userbd, this.passbd);
                Statement sentenciaPreparada = null;
                sentenciaPreparada = conexion2.createStatement();
                int cuantasuni = datosUsuario.getUnits().size();
                if (cuantasuni > 0) {
                    String unidades = this.arrayAParentesis(datosUsuario.getUnits());
                    String sql = "INSERT INTO main.userunits (unitid,userid) SELECT id," + idInsertado + " FROM main.units  WHERE id IN " + unidades;
                    sentenciaPreparada.execute(sql);
                }
            }
            if (tipoUsers2 != null) {
                String Resp = userid.toString();
                RespuestaValueDto respuestaValueDto = new RespuestaValueDto(idmensaje);
                estatus = HttpStatus.OK;
                ResponseEntity responseEntity = new ResponseEntity((Object)respuestaValueDto, estatus);
                return responseEntity;
            }
            respuesta = new RespuestaMsgDto("Fallo la actualizacion");
            estatus = HttpStatus.BAD_REQUEST;
            ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
            return responseEntity;
        }
        catch (Exception e) {
            respuesta = new RespuestaMsgDto("Error interno del servidor");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        return new ResponseEntity((Object)respuesta, estatus);
    }

    public String arrayAParentesis(List<Integer> lista) {
        if (lista == null || lista.isEmpty()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while (i < lista.size()) {
            sb.append(lista.get(i));
            if (i < lista.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @GetMapping(value={"/users/{userid}"})
    public ResponseEntity<?> getOneUsers(HttpServletRequest request, @PathVariable(value="userid") Integer userid) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        ArrayList listasUsersRolesPriWorStaDto = new ArrayList();
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        try {
            String var = "";
            boolean bloked = false;
            RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
            RolesResponseDto rolesResponseDto = new RolesResponseDto();
            Long cuantosregistro = 0L;
            ArrayList listasRoles = new ArrayList();
            ArrayList listasPrivelege = new ArrayList();
            String sessionid = request.getHeader("Authorization");
            Date fecha = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dataFormattata = formatter.format(fecha);
            Date fechaDate = formatter.parse(dataFormattata);
            AuditRequestDto auditDto = new AuditRequestDto();
            Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
            String SessionDuration = ((Params)deSessDuration.get()).getValue();
            int duracionSession = Integer.parseInt(SessionDuration);
            Date fecha2 = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fecha2);
            calendar.add(12, duracionSession);
            Date ValidThrufechaSalida = calendar.getTime();
            SimpleDateFormat salida = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String fechaComoCadena = salida.format(ValidThrufechaSalida);
            System.out.println(fechaComoCadena);
            if (sessionid == null) {
                respuesta.setMsg("Llamada al servicio malformado");
                ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
            if (encontreSessionUsuario.isPresent()) {
                String descestatus;
                Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
                fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
                if (fechaComoCadena == "") {
                    String var2 = "";
                    boolean bloked2 = false;
                    RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                    respuestaDto2.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
                    return responseEntity;
                }
                Roles roles = ((Users)encontreSessionUsuario.get()).getRolid();
                int idrol = roles.getId();
                int rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 630);
                if (rolisvalid == 0) {
                    RespuestaMsgDto respuestaPrivDto = new RespuestaMsgDto(var);
                    respuestaPrivDto.setMsg("No tiene los Privilegios");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuestaPrivDto, HttpStatus.FORBIDDEN);
                    return responseEntity;
                }
                boolean existeUsers = this.usersRepository.existsById((Object)userid);
                if (!existeUsers) {
                    respuesta.setMsg("Registro no encontrado");
                    ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, HttpStatus.NOT_FOUND);
                    return responseEntity;
                }
                List listaUserUnits = new ArrayList();
                Optional UsersElegido = this.usersRepository.findById((Object)userid);
                listaUserUnits = this.userunitsRepository.findByUserid(userid.intValue());
                ArrayList listasUnidadesDto = new ArrayList();
                ArrayList<UsersUnitDto> ListunitsAsociadas = new ArrayList<UsersUnitDto>();
                UnitsDto detalleUnits = new UnitsDto();
                for (Userunits units : listaUserUnits) {
                    UsersUnitDto detalleUserUnits = new UsersUnitDto();
                    int unitid = units.getUnitid();
                    Optional unidadselecc = this.unitsRepository.findById(unitid);
                    detalleUserUnits.setId(((Units)unidadselecc.get()).getId());
                    detalleUserUnits.setName(((Units)unidadselecc.get()).getDsc());
                    ListunitsAsociadas.add(detalleUserUnits);
                }
                ArrayList<StatusDto> listasStatus = new ArrayList<StatusDto>();
                ArrayList<WorkersUsersDto> listasWorkersUsersDto = new ArrayList<WorkersUsersDto>();
                ArrayList<SuppliersUsersDto> listasSuppliersUsersDto = new ArrayList<SuppliersUsersDto>();
                ArrayList<RolesUserDto> listasRolesUsersDto = new ArrayList<RolesUserDto>();
                UsersRolesPriWorStaDto detalleUsers = new UsersRolesPriWorStaDto();
                StatusDto detalleStatus = new StatusDto();
                WorkersUsersDto detalleworker = new WorkersUsersDto();
                SuppliersUsersDto detallesupplier = new SuppliersUsersDto();
                RolesUserDto detalleroles = new RolesUserDto();
                detalleUsers.setId(Integer.valueOf(((Users)UsersElegido.get()).getId()));
                detalleUsers.setUsr(((Users)UsersElegido.get()).getUsr());
                detalleUsers.setName(((Users)UsersElegido.get()).getName());
                detalleUsers.setEmail(((Users)UsersElegido.get()).getEmail());
                try {
                    detalleworker.setId(((Users)UsersElegido.get()).getWorkerid().getId());
                    detalleworker.setName(((Users)UsersElegido.get()).getWorkerid().getName());
                }
                catch (Exception e) {
                    detalleworker.setId(Integer.valueOf(0));
                    detalleworker.setName("");
                }
                listasWorkersUsersDto.add(detalleworker);
                try {
                    detallesupplier.setId(((Users)UsersElegido.get()).getSupplierid().getId());
                    detallesupplier.setName(((Users)UsersElegido.get()).getSupplierid().getName());
                }
                catch (Exception e) {
                    detallesupplier.setId(Integer.valueOf(0));
                    detallesupplier.setName("");
                }
                listasSuppliersUsersDto.add(detallesupplier);
                detalleStatus.setId(Integer.valueOf(((Users)UsersElegido.get()).getStatus()));
                if (((Users)UsersElegido.get()).getStatus() == 1) {
                    descestatus = "Activo";
                    detalleStatus.setName(descestatus);
                } else {
                    descestatus = "Inactivo";
                    detalleStatus.setName(descestatus);
                }
                listasStatus.add(detalleStatus);
                detalleroles.setId(Integer.valueOf(((Users)UsersElegido.get()).getRolid().getId()));
                detalleroles.setName(((Users)UsersElegido.get()).getRolid().getName());
                listasRolesUsersDto.add(detalleroles);
                detalleUsers.setWorker(detalleworker);
                detalleUsers.setSupplier(detallesupplier);
                detalleUsers.setStatus(detalleStatus);
                detalleUsers.setRole(detalleroles);
                detalleUsers.setUnits(ListunitsAsociadas);
                UserDetailsResponseDto entry = new UserDetailsResponseDto();
                entry.setEntry(detalleUsers);
                ResponseEntity responseEntity = ResponseEntity.ok((Object)entry);
                return responseEntity;
            }
            respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
            estatus = HttpStatus.UNAUTHORIZED;
            ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
            return responseEntity;
        }
        catch (Exception e) {
            respuesta.setMsg("Error interno del servidor");
            estatus = HttpStatus.INTERNAL_SERVER_ERROR;
            ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
            return responseEntity;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    @DeleteMapping(value={"/users/{userid}"})
    public ResponseEntity<?> borrarUsers(HttpServletRequest request, @PathVariable(value="userid") Integer userid) throws ParseException {
        RespuestaMsgDto respuesta = new RespuestaMsgDto("");
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        String var = "";
        boolean bloked = false;
        RespuestaDto respuestaDto = new RespuestaDto(var, bloked);
        String sessionid = request.getHeader("Authorization");
        Date fecha = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataFormattata = formatter.format(fecha);
        Date fechaDate = formatter.parse(dataFormattata);
        AuditRequestDto auditDto = new AuditRequestDto();
        String searchIn = "";
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        if (sessionid == null) {
            respuesta.setMsg("Llamada al servicio malformado");
            estatus = HttpStatus.BAD_REQUEST;
            return new ResponseEntity((Object)respuesta, estatus);
        }
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid = sessionid.substring(7));
        if (encontreSessionUsuario.isPresent()) {
            Date FechaReg = ((Users)encontreSessionUsuario.get()).getValidthru();
            String fechaComoCadena = this.securityService.consultarSessionActiva(FechaReg, fecha2, ((Users)encontreSessionUsuario.get()).getId());
            if (fechaComoCadena == "") {
                String var2 = "";
                boolean bloked2 = false;
                RespuestaMsgDto respuestaDto2 = new RespuestaMsgDto(var2);
                respuestaDto2.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
                return new ResponseEntity((Object)respuestaDto, HttpStatus.UNAUTHORIZED);
            }
            Roles roles = ((Users)encontreSessionUsuario.get()).getRolid();
            int idrol = roles.getId();
            int rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, 633);
            if (rolisvalid == 0) {
                RespuestaMsgDto respuestaPrivDto = new RespuestaMsgDto(var);
                respuestaPrivDto.setMsg("No tiene los Privilegios");
                return new ResponseEntity((Object)respuestaPrivDto, HttpStatus.FORBIDDEN);
            }
            try {
                if (this.usersRepository.existsById((Object)userid)) {
                    Optional usuDelete = this.usersRepository.findById((Object)userid);
                    String module = "Usuarios";
                    String Descmodule = "Se elimin\u00f3 a : " + ((Users)usuDelete.get()).getEmail();
                    auditDto.setIpaddr(HttpReqRespUtils.getClientIpAddressIfServletRequestExist());
                    String singo1 = "(";
                    String singo2 = ")";
                    String usryemail = ((Users)encontreSessionUsuario.get()).getUsr().concat(" ").concat(singo1).concat(((Users)encontreSessionUsuario.get()).getEmail().concat(singo2));
                    auditDto.setUserref(usryemail);
                    auditDto.setModule(module);
                    auditDto.setDesc(Descmodule);
                    auditDto.setCreatedat(fechaDate);
                    this.usersService.registrarAuditSesion(auditDto);
                    boolean valor = false;
                    try {
                        this.usersRepository.deleteusersbyid(userid);
                        RespuestaValueDto respuestaValueDto = new RespuestaValueDto(userid.intValue());
                        estatus = HttpStatus.OK;
                        ResponseEntity responseEntity = new ResponseEntity((Object)respuestaValueDto, estatus);
                        return responseEntity;
                    }
                    catch (Exception e) {
                        respuesta.setMsg("Error interno del servidor -conflicto. ");
                        estatus = HttpStatus.CONFLICT;
                        ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
                        if (this.entityManager != null && this.entityManager.isOpen()) {
                            this.entityManager.close();
                        }
                        return responseEntity;
                    }
                }
                respuesta.setMsg("Registro no encontrado");
                estatus = HttpStatus.NOT_FOUND;
                ResponseEntity responseEntity = new ResponseEntity((Object)respuesta, estatus);
                return responseEntity;
                {
                    catch (Exception e) {
                        respuesta.setMsg("Error interno del servidor");
                        estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                        ResponseEntity responseEntity2 = new ResponseEntity((Object)respuesta, estatus);
                        return responseEntity2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.entityManager != null && this.entityManager.isOpen()) {
                    this.entityManager.close();
                }
            }
        }
        respuesta.setMsg("Sesi\u00f3n expirada o inv\u00e1lida");
        estatus = HttpStatus.UNAUTHORIZED;
        return new ResponseEntity((Object)respuesta, estatus);
    }

    public boolean isAuthenticationSuccessful(String usuario, String password) {
        try {
            Authentication authentication = this.autheticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)usuario, (Object)password));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

