/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.entity;

import com.dacrt.SBIABackend.entity.Units;
import com.dacrt.SBIABackend.security.entity.Rol;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.springframework.lang.NonNull;

@Entity
@Table(name="usuario", schema="original_data")
public class Usuario {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @NotNull
    private String nombre;
    @NotNull
    @Column(unique=true)
    private String usuario;
    @NotNull
    private String email;
    @NotNull
    private String password;
    @NotNull
    @Column(columnDefinition="int4 not null default 1")
    private int activo;
    @NonNull
    @Column(columnDefinition="character varying(100) not null default 'x'")
    private String registradoPor;
    @NonNull
    @Column(columnDefinition="character varying(100) not null default 'x'")
    private String modificadoPor;
    @NonNull
    @Column(columnDefinition="timestamp without time zone NOT NULL default now()")
    private Date fechaRegistro;
    @Column(name="fechaModificacion")
    private Date fechaModificacion;
    @Column(name="fechaActualizacionClave")
    private Date fechaActualizacionClave;
    @Column(name="cod_Empleado", length=10, nullable=false, unique=true)
    private String codEmpleado;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="unidadUsuario", joinColumns={@JoinColumn(name="usuario_id")}, inverseJoinColumns={@JoinColumn(name="unidad_id")})
    private Set<Units> unidad = new HashSet();
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="usuario_rol", joinColumns={@JoinColumn(name="usuario_id")}, inverseJoinColumns={@JoinColumn(name="rol_id")})
    private Set<Rol> roles = new HashSet();

    public Usuario() {
    }

    public Usuario(@NotNull String nombre, @NotNull String usuario, @NotNull String email, @NotNull String password, @NotNull Set<Units> unidad, String codEmpleado) {
        this.nombre = nombre;
        this.usuario = usuario;
        this.email = email;
        this.password = password;
        this.unidad = unidad;
        this.codEmpleado = codEmpleado;
    }

    public Usuario(@NotNull String nombre, @NotNull String usuario, @NotNull String email, @NotNull String password, @NotNull String registradoPor, @NotNull Date fechaRegistro, String codEmpleado) {
        this.nombre = nombre;
        this.usuario = usuario;
        this.email = email;
        this.password = password;
        this.registradoPor = registradoPor;
        this.fechaRegistro = fechaRegistro;
        this.codEmpleado = codEmpleado;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNombre() {
        return this.nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<Units> getUnidad() {
        return this.unidad;
    }

    public void setUnidad(Set<Units> unidad) {
        this.unidad = unidad;
    }

    public Set<Rol> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Rol> roles) {
        this.roles = roles;
    }

    public int getActivo() {
        return this.activo;
    }

    public void setActivo(int activo) {
        this.activo = activo;
    }

    public String getRegistradoPor() {
        return this.registradoPor;
    }

    public void setRegistradoPor(String registradoPor) {
        this.registradoPor = registradoPor;
    }

    public String getModificadoPor() {
        return this.modificadoPor;
    }

    public void setModificadoPor(String modificadoPor) {
        this.modificadoPor = modificadoPor;
    }

    public Date getFechaRegistro() {
        return this.fechaRegistro;
    }

    public void setFechaRegistro(Date fechaRegistro) {
        this.fechaRegistro = fechaRegistro;
    }

    public Date getFechaModificacion() {
        return this.fechaModificacion;
    }

    public void setFechaModificacion(Date fechaModificacion) {
        this.fechaModificacion = fechaModificacion;
    }

    public Date getFechaActualizacionClave() {
        return this.fechaActualizacionClave;
    }

    public void setFechaActualizacionClave(Date fechaActualizacionClave) {
        this.fechaActualizacionClave = fechaActualizacionClave;
    }

    public String getCodEmpleado() {
        return this.codEmpleado;
    }

    public void setCodEmpleado(String codEmpleado) {
        this.codEmpleado = codEmpleado;
    }
}

