/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.service;

import com.dacrt.SBIABackend.security.dto.MenuDto;
import com.dacrt.SBIABackend.security.dto.MenuResponseDto;
import com.dacrt.SBIABackend.security.dto.RespuestaDto;
import com.dacrt.SBIABackend.security.dto.ShortcutsDto;
import com.dacrt.SBIABackend.security.dto.UsersResponseDto;
import com.dacrt.SBIABackend.security.entity.Access;
import com.dacrt.SBIABackend.security.entity.Menu;
import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.entity.Roles;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.AccessRepository;
import com.dacrt.SBIABackend.security.repository.AuditRepository;
import com.dacrt.SBIABackend.security.repository.MenuRepository;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class MenuService {
    private static final Integer Integer = null;
    Logger logger = LoggerFactory.getLogger(MenuService.class);
    private final Set<Integer> processedMenuIds = new HashSet();
    @Autowired
    MenuRepository menuRepository;
    @Autowired
    AuditRepository auditRepository;
    @Autowired
    UsersRepository usersRepository;
    @Autowired
    ParamsRepository paramsRepository;
    @Autowired
    AccessRepository accessRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Value(value="${var.ambiente}")
    private String urlAmbiente;
    @Value(value="${ambiente}")
    private String ambiente;
    @Value(value="${imagepath}")
    private String imagepath;
    @Value(value="${principal}")
    private String principal;
    @Value(value="${imagen}")
    private String imagen;
    @Value(value="${carpeta}")
    private String carpeta;
    @Value(value="${shorcuts}")
    private String shorcuts;
    @Autowired
    PasswordEncoder passworEncoder;

    public List<Menu> getAllMenu() {
        return this.menuRepository.findAll();
    }

    public boolean existsByUsr(String usr) {
        return this.usersRepository.existsByUsr(usr);
    }

    public boolean existsByEmail(String email) {
        return this.usersRepository.existsByEmail(email);
    }

    public boolean consultarSesionEstatus(Integer id) {
        boolean resp = false;
        int resp1 = this.usersRepository.consultarSesionEstatus(id);
        resp = resp1 == 1;
        return resp;
    }

    public List<MenuDto> buildMenuDto2(int father, String sessionid) {
        String ConcatAmbiente;
        String SentenciaBase = "";
        RespuestaDto respuesta = new RespuestaDto("", false);
        MenuDto menuDto2 = new MenuDto();
        ArrayList<MenuDto> menus = new ArrayList<MenuDto>();
        List resultados = new ArrayList();
        HttpStatus estatus = HttpStatus.FORBIDDEN;
        String svg = ".svg";
        String idcampo = "img/menu/";
        String ruta = ConcatAmbiente = this.urlAmbiente.concat(idcampo);
        boolean existe = false;
        try {
            try {
                Query query;
                if (father == 0) {
                    SentenciaBase = "SELECT      m.id,m.dsc,m.content,m.father, CASE WHEN m.privilegeid=0 THEN TRUE ELSE FALSE END AS acc FROM       main.menu m LEFT JOIN       (SELECT     privilegeid                  FROM       main.rolesprivileges RP                  INNER JOIN main.users U                  ON         RP.rolid=U.rolid                  WHERE sessionid=:sessionid ) RP ON         m.privilegeid=RP.privilegeid WHERE      m.id<>0 AND        m.father IS NULL order by   m.father,m.ord ";
                    query = this.entityManager.createNativeQuery(SentenciaBase);
                    query.setParameter("sessionid", (Object)sessionid);
                } else {
                    SentenciaBase = "SELECT     m.id,m.dsc,m.content,m.father, CASE WHEN RP.privilegeid IS NULL THEN FALSE ELSE TRUE END AS acc FROM       main.menu m LEFT JOIN       (SELECT     privilegeid                  FROM       main.rolesprivileges RP                  INNER JOIN main.users U                  ON         RP.rolid=U.rolid                  WHERE sessionid=:sessionid ) RP ON         m.privilegeid=RP.privilegeid WHERE      m.id<>0 AND        m.father=:father order by   m.ord asc";
                    query = this.entityManager.createNativeQuery(SentenciaBase);
                    query.setParameter("sessionid", (Object)sessionid);
                    query.setParameter("father", (Object)father);
                }
                resultados = query.getResultList();
                boolean idMenu = false;
                if (resultados.size() != 0) {
                    for (Object[] fila : resultados) {
                        menuDto2.setId(((Integer)fila[0]).intValue());
                        menuDto2.setDsc((String)fila[1]);
                        menuDto2.setContent((String)fila[2]);
                        String ruta_completa = ruta.concat(String.valueOf((Integer)fila[0])).concat(svg);
                        String filePath = this.ambiente.equals("/") ? String.valueOf(this.imagepath) + "/" + this.imagen + this.carpeta + menuDto2.getId() + svg : String.valueOf(this.imagepath) + "/" + this.principal + "/" + this.ambiente + this.imagen + this.carpeta + menuDto2.getId() + svg;
                        File archivo = new File(filePath);
                        if (archivo.exists()) {
                            menuDto2.setImage(ruta_completa);
                        } else {
                            menuDto2.setImage(null);
                        }
                        menuDto2.setEnabled(((Boolean)fila[4]).booleanValue());
                        menuDto2.setSubmenu(this.buildMenuDto2(menuDto2.getId(), sessionid));
                        menus.add(menuDto2);
                        menuDto2 = new MenuDto();
                    }
                }
            }
            catch (Exception e) {
                respuesta = new RespuestaDto("Error interno del servidor", false);
                estatus = HttpStatus.INTERNAL_SERVER_ERROR;
                if (this.entityManager != null && this.entityManager.isOpen()) {
                    this.entityManager.close();
                }
            }
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        return menus;
    }

    public List<MenuDto> buildMenuDto(List<Menu> menuEntities, String sessionid) {
        this.processedMenuIds.clear();
        return menuEntities.stream().map(menuEntity -> this.mapMenuEntityToDto(menuEntity, sessionid)).collect(Collectors.toList());
    }

    private MenuDto mapMenuEntityToDto(Menu menuEntity, String sessionid) {
        String ConcatAmbiente;
        if (this.processedMenuIds.contains(menuEntity.getId())) {
            return new MenuDto();
        }
        this.processedMenuIds.add(menuEntity.getId());
        String svg = ".svg";
        String png = ".png";
        String jpeg = ".jpeg";
        String jpg = ".jpg";
        MenuDto menuDto = new MenuDto();
        menuDto.setId(menuEntity.getId());
        menuDto.setDsc(menuEntity.getDsc());
        String idcampo = "img/menu/";
        String ruta = ConcatAmbiente = this.urlAmbiente.concat(idcampo);
        String filePath = ruta.concat(String.valueOf(menuEntity.getId())).concat(svg);
        boolean existe = false;
        int responseCode = 0;
        try {
            URL url = new URL(filePath);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            responseCode = huc.getResponseCode();
            if (responseCode == 200) {
                menuDto.setImage(filePath);
            } else {
                menuDto.setImage(null);
            }
        }
        catch (Exception e) {
            menuDto.setImage(null);
        }
        int tiene = responseCode;
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid);
        int permiso = menuEntity.getPrivilegeid();
        Roles roles = ((Users)encontreSessionUsuario.get()).getRolid();
        int idrol = roles.getId();
        int rolisvalid = this.auditRepository.getCantbyRolAndPrivi(idrol, permiso);
        if (permiso == 0) {
            menuDto.setEnabled(true);
        } else if (rolisvalid == 0) {
            menuDto.setEnabled(false);
        } else {
            menuDto.setEnabled(true);
        }
        rolisvalid = 0;
        menuDto.setContent(menuEntity.getContent());
        ArrayList currentMenu = new ArrayList();
        if (!menuEntity.getSubmenus().isEmpty()) {
            List submenus = menuEntity.getSubmenus().stream().map(submenuEntity -> this.mapMenuEntityToDto(submenuEntity, sessionid)).collect(Collectors.toList());
            menuDto.setSubmenu(submenus);
        } else {
            ArrayList submenus = new ArrayList();
            menuDto.setSubmenu(submenus);
        }
        return menuDto;
    }

    public MenuResponseDto getMenu(String sessionid) {
        MenuResponseDto menuDto = new MenuResponseDto();
        RespuestaDto respuesta = new RespuestaDto("", false);
        ShortcutsDto shorcutsdto = new ShortcutsDto();
        ArrayList<ShortcutsDto> listashortcuts = new ArrayList<ShortcutsDto>();
        Optional deSessDuration = this.paramsRepository.findByParamname("SESSION_DURATION");
        String SessionDuration = ((Params)deSessDuration.get()).getValue();
        int duracionSession = Integer.parseInt(SessionDuration);
        Date fecha2 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fecha2);
        calendar.add(12, duracionSession);
        Date ValidThrufechaSalida = calendar.getTime();
        SimpleDateFormat salida = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String fechaComoCadena = salida.format(ValidThrufechaSalida);
        Optional encontreSessionUsuario = this.usersRepository.getBySessionid(sessionid);
        if (encontreSessionUsuario.isPresent()) {
            String ConcatAmbiente;
            UsersResponseDto usuario = new UsersResponseDto();
            usuario.setName(((Users)encontreSessionUsuario.get()).getName());
            int iduser = ((Users)encontreSessionUsuario.get()).getId();
            String idcampo = "img/logo.png";
            String ruta = ConcatAmbiente = this.urlAmbiente.concat(idcampo);
            String desPadre = "";
            String desContentPadre = "";
            menuDto.setUser(usuario);
            menuDto.setValidthru(fechaComoCadena);
            List accessDtoString = this.accessRepository.getAllAccessxUserMax(Integer.valueOf(((Users)encontreSessionUsuario.get()).getId()));
            String label = "";
            for (String acceso : accessDtoString) {
                String ConcatAmbienteShort;
                Optional menushort = this.menuRepository.findByContent(acceso);
                int tienepadre = this.menuRepository.findByContentCount(acceso);
                if (tienepadre == 1) {
                    int Valor = ((Menu)menushort.get()).getFather().getId();
                    if (this.menuRepository.findByFather(Integer.valueOf(Valor)).get() != null && ((Menu)this.menuRepository.findByFather(Integer.valueOf(Valor)).get()).getFather() != null && ((Menu)this.menuRepository.findByFather(Integer.valueOf(Valor)).get()).getFather().getId() > 0) {
                        desPadre = this.menuRepository.findByDscPadre(Integer.valueOf(((Menu)this.menuRepository.findByFather(Integer.valueOf(Valor)).get()).getFather().getId()));
                        desContentPadre = this.menuRepository.findByContentDesc(desPadre, Integer.valueOf(((Menu)this.menuRepository.findByFather(Integer.valueOf(Valor)).get()).getFather().getId()));
                        label = String.valueOf(((Menu)menushort.get()).getFather().getDsc()) + " - " + ((Menu)menushort.get()).getDsc();
                    } else {
                        desPadre = this.menuRepository.findByDscPadre(Integer.valueOf(((Menu)menushort.get()).getFather().getId()));
                        desContentPadre = this.menuRepository.findByContentDesc(desPadre, Integer.valueOf(((Menu)menushort.get()).getFather().getId()));
                        label = ((Menu)menushort.get()).getDsc();
                    }
                    int valor2 = Valor;
                    String string = desPadre;
                } else {
                    String papa = desPadre = "";
                    desContentPadre = ((Menu)menushort.get()).getContent();
                    label = ((Menu)menushort.get()).getDsc();
                }
                ShortcutsDto detalleShortcuts = new ShortcutsDto();
                detalleShortcuts.setLabel(label);
                detalleShortcuts.setGroup(desPadre);
                detalleShortcuts.setOpt(((Menu)menushort.get()).getContent());
                label = "";
                String svg = ".svg";
                String idcampoShort = "img/shortcuts/";
                String rutaShort = ConcatAmbienteShort = this.urlAmbiente.concat(idcampoShort);
                String ruta_completa = rutaShort.concat(desContentPadre).concat(svg);
                String filePathshort = this.ambiente.equals("/") ? String.valueOf(this.imagepath) + "/" + this.imagen + this.shorcuts + desContentPadre + svg : String.valueOf(this.imagepath) + "/" + this.principal + "/" + this.ambiente + this.imagen + this.shorcuts + desContentPadre + svg;
                System.out.println(filePathshort);
                boolean existe = false;
                boolean responseCode = false;
                File archivo = new File(filePathshort);
                if (archivo.exists()) {
                    detalleShortcuts.setImage(ruta_completa);
                } else {
                    detalleShortcuts.setImage(null);
                }
                listashortcuts.add(detalleShortcuts);
            }
            menuDto.setShortcuts(listashortcuts);
            Optional mainMessage = this.paramsRepository.findByParamname("MAIN_MESSAGE");
            menuDto.setMainmessage(((Params)mainMessage.get()).getValue());
            List menusDto = new ArrayList();
            menusDto = this.buildMenuDto2(0, sessionid);
            menuDto.setOptions(menusDto);
            this.usersRepository.asociarcambioValidthru(Integer.valueOf(((Users)encontreSessionUsuario.get()).getId()), ValidThrufechaSalida);
        } else {
            menuDto = null;
        }
        return menuDto;
    }

    public void iscontentdiffnull(String content, int userid) {
        try {
            Date fecha = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat formatter2 = new SimpleDateFormat("HH:mm:ss");
            String dataFormattata = formatter.format(fecha);
            String dataFormattata2 = formatter2.format(fecha);
            Date fechaDate = formatter.parse(dataFormattata);
            Access detalleAcces = new Access();
            if (content == "") {
                String string = "No pasa nada";
            } else {
                boolean existeContent = this.accessRepository.existsByContentAndUserid(content, Integer.valueOf(userid));
                if (existeContent) {
                    this.accessRepository.deleteContentUser(Integer.valueOf(userid), content);
                    detalleAcces.setUserid(userid);
                    detalleAcces.setContent(content);
                    detalleAcces.setDate(fechaDate);
                    this.accessRepository.save((Object)detalleAcces);
                } else {
                    detalleAcces.setUserid(userid);
                    detalleAcces.setContent(content);
                    detalleAcces.setDate(fechaDate);
                    this.accessRepository.save((Object)detalleAcces);
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

