/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.service;

import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import java.text.Normalizer;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ParamsService {
    Logger logger = LoggerFactory.getLogger(ParamsService.class);
    @Autowired
    ParamsRepository paramsRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${spring.datasource.url}")
    private String conexion;
    @Value(value="${spring.datasource.username}")
    private String userbd;
    @Value(value="${spring.datasource.password}")
    private String passbd;

    public boolean existsById(Integer id_tipoinsumo) {
        return this.paramsRepository.existsById((Object)id_tipoinsumo);
    }

    public Params getParamsByid(Integer id) {
        Params tipoInsumo = (Params)this.paramsRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("No se encontro el parametro con id: " + id));
        return tipoInsumo;
    }

    public Params addIdParams(Params tipoParams) {
        return (Params)this.paramsRepository.save((Object)tipoParams);
    }

    public static String quitarAcentosJava(String texto) {
        if (texto == null || texto.isEmpty()) {
            return texto;
        }
        String textoNormalizado = Normalizer.normalize(texto, Normalizer.Form.NFD);
        String textoSinAcentos = textoNormalizado.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        return textoSinAcentos;
    }

    public int converttoMinute(String filterIn, int cantidad) {
        int quantitytotal;
        if (filterIn == null || filterIn.isEmpty()) {
            return 0;
        }
        String filterOut = "";
        String valueOut = "";
        String query = " SELECT elemento ->> 'filter' AS filter,elemento ->> 'value' AS valor FROM main.params p, jsonb_array_elements(CAST(p.value AS jsonb)) AS elemento WHERE paramname = 'EVALPROC_PERIOD' AND elemento ->> 'value' = '" + filterIn + "'";
        Query queryPeriodo = this.entityManager.createNativeQuery(query);
        Long cuantosregistro = queryPeriodo.getResultList().size();
        if (cuantosregistro > 0L) {
            List listaperiodos = queryPeriodo.getResultList();
            for (Object[] typesperi : listaperiodos) {
                filterOut = (String)typesperi[0];
                valueOut = (String)typesperi[1];
            }
            int filterOutInt = Integer.parseInt(filterOut);
            int valueOutInt = Integer.parseInt(valueOut);
            quantitytotal = cantidad * filterOutInt;
        } else {
            quantitytotal = -1;
        }
        return quantitytotal;
    }
}

