/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.service;

import com.dacrt.SBIABackend.security.dto.RolAccesoDto;
import com.dacrt.SBIABackend.security.entity.Rol;
import com.dacrt.SBIABackend.security.entity.RolOpcionDeBIA;
import com.dacrt.SBIABackend.security.repository.RolOpcionDeBIARepository;
import com.dacrt.SBIABackend.security.repository.RolRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class RolService {
    @Autowired
    RolRepository rolRepository;
    @Autowired
    RolOpcionDeBIARepository rolOpcionDeBIARepository;

    public Optional<Rol> getByRolNombre(String rolNombre) {
        return this.rolRepository.findByRolNombre(rolNombre);
    }

    public List<RolAccesoDto> getRoles() {
        ArrayList<RolAccesoDto> listaRoles = new ArrayList<RolAccesoDto>();
        List roles = StreamSupport.stream(this.rolRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Rol rol : roles) {
            RolAccesoDto rolAccesoDto = new RolAccesoDto(rol.getId(), rol.getRolNombre());
            listaRoles.add(rolAccesoDto);
        }
        return listaRoles;
    }

    public void save(Rol rol) {
        this.rolRepository.save((Object)rol);
    }

    public Set<RolOpcionDeBIA> buscarOpcionesDeRol(String rolNombre) {
        Optional optionalRol = this.getByRolNombre(rolNombre);
        HashSet<RolOpcionDeBIA> rolesOpcionesDeBIA = optionalRol.isPresent() ? this.rolOpcionDeBIARepository.findByRol((Rol)optionalRol.get()) : new HashSet<RolOpcionDeBIA>();
        return rolesOpcionesDeBIA;
    }

    public boolean existsByRolNombre(String rolNombre) {
        return this.rolRepository.existsByRolNombre(rolNombre);
    }
}

