/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.security.service;

import com.dacrt.SBIABackend.security.dto.AuditRequestDto;
import com.dacrt.SBIABackend.security.entity.Audit;
import com.dacrt.SBIABackend.security.entity.Params;
import com.dacrt.SBIABackend.security.entity.Users;
import com.dacrt.SBIABackend.security.repository.AuditRepository;
import com.dacrt.SBIABackend.security.repository.ParamsRepository;
import com.dacrt.SBIABackend.security.repository.RolesRepository;
import com.dacrt.SBIABackend.security.repository.UsersRepository;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class UsersService {
    Logger logger = LoggerFactory.getLogger(UsersService.class);
    @Autowired
    UsersRepository usersRepository;
    @Autowired
    AuditRepository auditRepository;
    @Autowired
    RolesRepository rolesRepository;
    @Autowired
    ParamsRepository paramsRepository;
    @Autowired
    PasswordEncoder passworEncoder;
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="$(spring.mail.username)")
    private String fromEmailId;
    @Value(value="${spring.mail.port}")
    private String puerto;
    @Value(value="${spring.mail.host}")
    private String hostemail;
    @Value(value="${spring.mail.username}")
    private String usersemail;
    @Value(value="${spring.mail.password}")
    private String pwdemail;
    @Value(value="${spring.mail.protocol}")
    private String protocolo;
    @Value(value="${spring.mail.properties.mail.smtp.auth}")
    private String auth;
    @Value(value="${spring.mail.properties.mail.smtp.starttls.enabled}")
    private String starttls;
    Date fechaActual = new Date();

    public void sendEmail(String recipient, String body, String subject) {
        SimpleMailMessage simpleMailMessage = new SimpleMailMessage();
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
            message.setContent((Object)body, "text/html; charset=utf-8");
            message.setSubject(subject);
            message.setFrom((Address)new InternetAddress(this.usersemail));
            this.mailSender.send(message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public Optional<Users> getByUsr(String usr) {
        return this.usersRepository.findByUsr(usr);
    }

    public Optional<Users> getByEmail(String email) {
        return this.usersRepository.findByEmail(email);
    }

    public boolean existsByUsr(String usr) {
        return this.usersRepository.existsByUsr(usr);
    }

    public boolean existsByEmail(String email) {
        return this.usersRepository.existsByEmail(email);
    }

    public Users getUsersByid(Integer id) {
        Users tipoUsers = (Users)this.usersRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("No se encontro el parametro con id: " + id));
        return tipoUsers;
    }

    public boolean existsById(Integer id) {
        return this.usersRepository.existsById((Object)id);
    }

    public void save(Users usr) {
        this.usersRepository.save((Object)usr);
    }

    public Users getUsr(Integer id) {
        Users usr = (Users)this.usersRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Usuario con id: " + id + " no puede ser encontrado"));
        return usr;
    }

    public String ArmarBodySendMailUser(String ruta, String usuario, String saludo, String url, String accion, String minlong, String cantMay, String cantMin, String cantSimbo, String simPermi) {
        String contenido = "";
        contenido = String.format("<html> <body> <div id='1' style='background-color: #F8F8F8;width: 875px;height: 550px;background-position-x: 320px; background-position-y: 240px;' > <div style='margin:0 auto;text-align:center;background-color: #354856;width: 377px;height: 170px;background-position-x: 320px; background-position-y: 241px;'> <img style='margin-top: 40px;width: 200px;height: 87px;' src='%s' alt='logo'> </div> <div style='border:1px solid #FFF;margin:0 auto;background-color: #FFFFFF;width: 377px;height: 377px;background-position-x: 596px; background-position-y: 404px;'> <div id='2' > <div style='font-weight:bold;margin:15px auto 5px auto; text-align:center;font-weight:bold;color: #152228;font-family: Arial, Helvetica, sans-serif;font-size: 18px;line-height: 22px;width: 266px;'> Hola, <b>%s</b> </div> <div style='font-weight:bold;margin:12px auto 20px auto;width:380px;color: #4c4c4d;font-family: Roboto;font-size: 15px;letter-spacing: 0.22px;line-height: 16px;width: 266px;text-align:center;'>  %s</div> </div> <div style='text-align:center;padding: 10px;'> <a style='background-color: #EA8B1D;border-radius: 9px;text-align:center;padding: 9px 86px;font-family: Arial, Helvetica, sans-serif;text-transform: uppercase;color:#fff;' href='%s'><b> %s </b></a> </div> <div style='background-color: #f5f3f3;border-radius: 6px;width: 266px;height: 170px;background-position-x: 625px; background-position-y: 585px;margin:10px auto 0 auto;'> <div id='2' style='padding:10px;color: #828386;font-family: Roboto;font-size: 14px;line-height: 15px;  width: 244px;text-align: left;'> <div style='font-weight:bold;margin-bottom:7px;color: #828386;font-family: Roboto;font-size: 12px;line-height: 14px;width: 244px;text-align: left;'>Le recordamos que la contrase\u00f1a debe cumplir con los siguientes requerimientos:</div> <div style='font-weight:bold;color: #828386;font-family: Roboto;font-size: 12px;line-height: 15px;width: 244px;text-align: left;padding:3px 0;'> &#10004; Longitud M\u00ednima: %s </div> <div style='font-weight:bold;color: #828386;font-family: Roboto;font-size: 12px;line-height: 15px;width: 244px;text-align: left;padding:3px 0;'> &#10004; Cantidad de May\u00fasculas: %s </div> <div style='font-weight:bold;color: #828386;font-family: Roboto;font-size: 12px;line-height: 15px;width: 244px;text-align: left;padding:3px 0;'> &#10004; Cantidad de M\u00edn\u00fasculas: %s </div> <div style='font-weight:bold;color: #828386;font-family: Roboto;font-size: 12px;line-height: 15px;width: 244px;text-align: left;padding:3px 0;'> &#10004; Cantidad de S\u00edmbolos: %s </div> <div style='font-weight:bold;color: #828386;font-family: Roboto;font-size: 12px;line-height: 15px;width: 244px;text-align: left;padding:3px 0;'> &#10004; S\u00edmbolos Permitidos: %s </div> </div> </div> </div> </div> </body> </html>", ruta, usuario, saludo, url, accion, minlong, cantMay, cantMin, cantSimbo, simPermi);
        return contenido;
    }

    public String eliminarAcentosService(String texto) {
        String normalized = Normalizer.normalize(texto, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(normalized).replaceAll("");
    }

    public String verificarCaracteresValidos(String texto) throws UnsupportedEncodingException {
        Optional deCarateresPerTextbox = this.paramsRepository.findByParamname("TEXTBOX_ALLOWED");
        String caracterespermi = ((Params)deCarateresPerTextbox.get()).getValue();
        String encoding2 = StandardCharsets.UTF_8.toString();
        String caracteresCodificados2 = URLEncoder.encode(caracterespermi, encoding2);
        String salida = "OK";
        int i = 0;
        while (i < texto.length()) {
            char currentChar = texto.charAt(i);
            String var = String.valueOf(currentChar);
            String VcurrentChar = URLEncoder.encode(var, encoding2);
            if (caracterespermi.indexOf(var) == -1) {
                salida = "NOOK";
            }
            ++i;
        }
        return salida;
    }

    public String verificarCaracteresValidosConRegex(String texto) {
        Optional deCarateresPerTextbox = this.paramsRepository.findByParamname("TEXTBOX_ALLOWED");
        if (!deCarateresPerTextbox.isPresent()) {
            return "ERROR_CONFIGURACION_NO_ENCONTRADA";
        }
        String caracterespermi = ((Params)deCarateresPerTextbox.get()).getValue();
        String regex = "[^" + Pattern.quote(caracterespermi) + "]";
        Pattern patronNoPermitido = Pattern.compile(regex);
        if (patronNoPermitido.matcher(texto).find()) {
            return "NOOK";
        }
        return "OK";
    }

    public boolean consultarSesionEstatus(Integer id) {
        boolean resp = false;
        int resp1 = this.usersRepository.consultarSesionEstatus(id);
        resp = resp1 == 1;
        return resp;
    }

    public Audit registrarAuditSesion(AuditRequestDto auditDto) {
        Audit auditTo = new Audit();
        auditTo.setIpaddr(auditDto.getIpaddr());
        auditTo.setCreatedat(auditDto.getCreatedat());
        auditTo.setModule(auditDto.getModule());
        auditTo.setDsc(auditDto.getDesc());
        auditTo.setUserref(auditDto.getUserref());
        return (Audit)this.auditRepository.save((Object)auditTo);
    }

    public void asociarSessionidUsers(Integer id, String jwt, Date fechaDate, int fail, int idestatus) {
        this.usersRepository.asociarSessionidydatos(id, jwt, fechaDate, fail, idestatus);
    }

    public void asociarSessionidUsersValid(Integer id, String jwt, Date fechaDate, int fail, int idestatus, Date validthru) {
        this.usersRepository.asociarSessionidydatosvalid(id, jwt, fechaDate, fail, idestatus, validthru);
    }

    public Users addIdUsers(Users tipoUsers) {
        return (Users)this.usersRepository.save((Object)tipoUsers);
    }
}

