/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.LabelItemDtoReport2;
import com.dacrt.SBIABackend.dto.LabelValueDtoReport2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppteststatusService {
    Logger logger = LoggerFactory.getLogger(AppteststatusService.class);
    @PersistenceContext
    private EntityManager entityManager;

    public List<LabelItemDtoReport2> getAppeststatus(String fecha) {
        ArrayList<LabelItemDtoReport2> finalReportList = new ArrayList<LabelItemDtoReport2>();
        String fecha2 = fecha;
        int ano = 0;
        int mes = 0;
        int dia = 0;
        ano = Integer.parseInt(fecha2.substring(0, 4));
        mes = Integer.parseInt(fecha2.substring(4, 6));
        dia = Integer.parseInt(fecha2.substring(6, 8));
        try {
            String SentenciaBase = " WITH ParamMaps AS (     SELECT elem->>'value' AS value, elem->>'dsc' AS descr, paramname     FROM main.params, jsonb_array_elements(CAST(value AS jsonb)) AS elem     WHERE paramname IN ('APPS_TESTTYPE', 'APPS_TESTRESULT') ), FilteredApplications AS (     SELECT         a.id AS idApplication,         CAST(a.drptesttypepar AS TEXT) AS drptesttypepar_val,         CAST(a.drptestresultpar AS TEXT) AS drptestresultpar_val,         a.drptestedpar     FROM main.applications a     JOIN main.evalprocapps EPA ON a.id = EPA.applicationid     JOIN main.evalprocesses EP ON EP.id = EPA.evalprocessid     JOIN main.campaignunits CU ON EP.campaignunitid = CU.id     JOIN main.evalprocimpacts EI ON EP.id = EI.evalprocessid     JOIN main.campaigns C ON CU.campaingid = C.id     WHERE EP.appst =1 AND         CAST(EP.createdat AS date) <= TO_DATE('" + ano + "-" + mes + "-" + dia + "','YYYY/MM/DD') " + "        AND EI.rtoqty <= 1440 " + "  AND (CAST(a.drptestdate as date)  <= TO_DATE('" + ano + "-" + mes + "-" + dia + "','YYYY/MM/DD') OR a.drptestdate IS NULL)" + "        AND C.Dateto = ( " + "            SELECT " + "                MAX(C2.Dateto) " + "            FROM main.campaigns C2 " + "            JOIN main.campaignunits CU2 ON C2.id = CU2.campaingid " + "            JOIN main.evalprocesses EP2 ON CU2.id = EP2.campaignunitid " + "            JOIN main.evalprocapps EPA2 ON EP2.id = EPA2.evalprocessid " + "            WHERE EPA2.applicationid = a.id " + "              AND CAST(C2.datefrom AS date) <= TO_DATE('" + ano + "-" + mes + "-" + dia + "','YYYY/MM/DD') " + "        ) " + "), " + "ActualApplicationCounts AS ( " + "    SELECT " + "        CASE " + "            WHEN fa.drptestedpar = 1 THEN TTP.descr " + "            WHEN fa.drptestedpar = 2 THEN 'Sin Tipo de Prueba' " + "            ELSE 'Desconocido' " + "        END AS TipoPrueba, " + "        CASE " + "            WHEN fa.drptestedpar = 1 AND fa.drptestresultpar_val IS NOT NULL THEN TRP.descr " + "            WHEN fa.drptestedpar = 1 AND fa.drptestresultpar_val IS NULL THEN 'Sin Resultado' " + "            WHEN fa.drptestedpar = 2 AND fa.drptestresultpar_val IS NOT NULL THEN TRP.descr " + "            WHEN fa.drptestedpar = 2 AND fa.drptestresultpar_val IS NULL THEN 'Sin Resultado' " + "            ELSE 'Desconocido' " + "        END AS ResultadoPrueba, " + "        COUNT(DISTINCT fa.idApplication) AS TotalRegistros " + "    FROM FilteredApplications fa " + "    LEFT JOIN ParamMaps TTP ON TTP.paramname = 'APPS_TESTTYPE' AND TTP.value = fa.drptesttypepar_val " + "    LEFT JOIN ParamMaps TRP ON TRP.paramname = 'APPS_TESTRESULT' AND TRP.value = fa.drptestresultpar_val " + "    GROUP BY " + "        CASE WHEN fa.drptestedpar = 1 THEN TTP.descr WHEN fa.drptestedpar = 2 THEN 'Sin Tipo de Prueba' ELSE 'Desconocido' END, " + "        CASE WHEN fa.drptestedpar = 1 AND fa.drptestresultpar_val IS NOT NULL THEN TRP.descr WHEN fa.drptestedpar = 1 AND fa.drptestresultpar_val IS NULL THEN 'Sin Resultado' WHEN fa.drptestedpar = 2 AND fa.drptestresultpar_val IS NOT NULL THEN TRP.descr WHEN fa.drptestedpar = 2 AND fa.drptestresultpar_val IS NULL THEN 'Sin Resultado' ELSE 'Desconocido' END " + "), " + "AllDesiredCombinations AS ( " + "    SELECT " + "        P1.descr AS TipoPrueba, " + "        P2.descr AS ResultadoPrueba " + "    FROM ParamMaps P1 " + "    CROSS JOIN ParamMaps P2 " + "    WHERE P1.paramname = 'APPS_TESTTYPE' AND P2.paramname = 'APPS_TESTRESULT' " + " " + "    UNION ALL " + " " + "    SELECT " + "        P1.descr AS TipoPrueba, " + "        'Sin Resultado' AS ResultadoPrueba " + "    FROM ParamMaps P1 " + "    WHERE P1.paramname = 'APPS_TESTTYPE' AND P1.descr IN ('Unitaria', 'General', 'Full Day') " + " " + "    UNION ALL " + " " + "    SELECT " + "        'Sin Tipo de Prueba' AS TipoPrueba, " + "        P2.descr AS ResultadoPrueba " + "    FROM ParamMaps P2 " + "    WHERE P2.paramname = 'APPS_TESTRESULT' " + " " + "    UNION ALL " + " " + "    SELECT 'Sin Tipo de Prueba' AS TipoPrueba, 'Sin Resultado' AS ResultadoPrueba " + "), " + "FinalReportData AS ( " + "    SELECT " + "        ADC.TipoPrueba, " + "        ADC.ResultadoPrueba, " + "        COALESCE(AAC.TotalRegistros, 0) AS TotalRegistros " + "    FROM AllDesiredCombinations ADC " + "    LEFT JOIN ActualApplicationCounts AAC " + "        ON ADC.TipoPrueba = AAC.TipoPrueba AND ADC.ResultadoPrueba = AAC.ResultadoPrueba " + ") " + "SELECT " + "    TipoPrueba, " + "    ResultadoPrueba, " + "    TotalRegistros, " + " COALESCE( " + "        ROUND( " + "            (CAST(TotalRegistros AS NUMERIC) / NULLIF(SUM(TotalRegistros) OVER (), 0)) * 100, " + "            2 " + "        ), " + "        0.00  " + "    ) AS Porcentaje " + " FROM FinalReportData " + "ORDER BY " + "    CASE " + "        WHEN TipoPrueba = 'Unitaria' THEN 1 " + "        WHEN TipoPrueba = 'General' THEN 2 " + "        WHEN TipoPrueba = 'Full Day' THEN 3 " + "        WHEN TipoPrueba = 'Sin Tipo de Prueba' THEN 4 " + "        ELSE 99 " + "    END, " + "    CASE " + "        WHEN ResultadoPrueba = 'Exitoso' THEN 1 " + "        WHEN ResultadoPrueba = 'Parcial' THEN 2 " + "        WHEN ResultadoPrueba = 'Fallido' THEN 3 " + "        WHEN ResultadoPrueba = 'Sin Resultado' THEN 4 " + "        ELSE 99 " + "    END ";
            Query query = this.entityManager.createNativeQuery(SentenciaBase);
            List listacompleta = query.getResultList();
            LabelItemDtoReport2 currentGroup = null;
            String lastTipoPruebaProcessed = null;
            for (Object[] reg : listacompleta) {
                String tipoPruebaActual = (String)reg[0];
                String resultadoPrueba = (String)reg[1];
                BigDecimal totalRegistros = (BigDecimal)reg[3];
                if (currentGroup == null || !tipoPruebaActual.equals(lastTipoPruebaProcessed)) {
                    currentGroup = new LabelItemDtoReport2();
                    currentGroup.setLabel(tipoPruebaActual);
                    finalReportList.add(currentGroup);
                }
                LabelValueDtoReport2 detailItem = new LabelValueDtoReport2();
                detailItem.setLabel(resultadoPrueba);
                detailItem.setValue(totalRegistros != null ? totalRegistros : BigDecimal.ZERO);
                if (currentGroup.getItems() == null) {
                    currentGroup.setItems(new ArrayList());
                }
                currentGroup.getItems().add(detailItem);
                lastTipoPruebaProcessed = tipoPruebaActual;
            }
            ArrayList<LabelItemDtoReport2> arrayList = finalReportList;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("Error al obtener la cobertura BCP: {}", (Object)e.getMessage(), (Object)e);
            ArrayList<LabelItemDtoReport2> arrayList = new ArrayList<LabelItemDtoReport2>();
            return arrayList;
        }
        finally {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
    }
}

